#include "ExtData.hh"
#include "ZUtils.hh"

#ifdef HAVE_ZLIB
#include <iostream>

ExtData::ExtData(const vector<string> &markers, const string &filename) :
    m_output(true), m_io(gzopen(filename.c_str(), "wb")), m_marker_names(markers) {
  write(m_io, markers, true);
}

vector<unsigned int> ExtData::markerIndex(const vector<string> &markers) const {
  vector<unsigned int> r;
  for (unsigned int i = 0; i < markers.size(); i++) {
    unsigned int j = 0;
    while (j < m_marker_names.size() && m_marker_names[j] != markers[i]) j++;
    if (j < m_marker_names.size())
      r.push_back(j);
  }
  return r;
}
#endif
