#ifndef _EXTDATA_HH
#define _EXTDATA_HH

#include "ExtFamily.hh"

#ifdef HAVE_ZLIB
#include <zlib.h>

class ExtData {
public:
  /// Output constructor
  ExtData(const vector<string> &markers, const string &filename);

  ~ExtData() {if (m_output) gzclose(m_io);}

  ExtFamily &addFamily() {
    m_families.push_back(ExtFamily(&m_io));
//    m_informative.push_back(true);
    return m_families.back();
  }
  void dropFamily() {
    m_families.pop_back();
//    m_informative.pop_back();
  }
  ExtFamily &back() {return m_families.back();}
  ExtFamily &getFamily(unsigned int idx) {return m_families[idx];}
  unsigned int numFamilies() const {return m_families.size();}
  const vector<string> &getMarkers() const {return m_marker_names;}

  vector<unsigned int> markerIndex(const vector<string> &markers) const;

protected:
  const bool m_output;
  gzFile m_io;
  vector<string> m_marker_names;
  vector<ExtFamily> m_families;
  
};

#endif
#endif // _EXTDATA_HH
