#include "ExtFamily.hh"
#include "ZUtils.hh"

#ifdef HAVE_ZLIB
#include <iostream>

#include <assert.h>

void ExtFamily::write(const string &id, const vector<string> &founders,
                      bool exact_results,
                      const vector<vector<unsigned int> > &founder_config,
                      const vector<vector<unsigned int> > &affected_config) {
  assert(founder_config.size() == affected_config.size());
  ::write(*m_io, id);
  ::write(*m_io, founders, true);
  ::write(*m_io, exact_results);
  
  for (unsigned int i = 0; i < m_configs.size(); i++)
    m_configs[i].write(*m_io);
  
  ::write(*m_io, founder_config.size());
  for (unsigned int i = 0; i < founder_config.size(); i++) {
    ::write(*m_io, founder_config[i]);
    ::write(*m_io, affected_config[i]);
  }
}
#endif
