#ifndef _EXTFAMILY_HH
#define _EXTFAMILY_HH

#include "MarkerConfig.hh"

#ifdef HAVE_ZLIB
#include <zlib.h>

class ExtFamily {
public:
  /// Output constructor
  ExtFamily(gzFile *io) : m_output(true), m_id(""), m_io(io) {}

  MarkerConfig &addConfig() {
    m_configs.push_back(MarkerConfig());
    return m_configs.back();
  }

  void write(const string &id, const vector<string> &founders,
             bool exact_results,
             const vector<vector<unsigned int> > &founder_config,
             const vector<vector<unsigned int> > &affected_config);

  const string &getId() const {return m_id;}

protected:
  bool m_output;
  string m_id;
  unsigned int m_num_founders;
  bool m_exact_results;
  gzFile *m_io;
  vector<MarkerConfig> m_configs;
  typedef pair<vector<unsigned int>, vector<unsigned int> > IVPath;
  vector<IVPath> m_iv_paths;
  bool m_informative;
//  vector<string> m_affecteds;
//  vector<string> m_founders;

};

#endif
#endif // _EXTFAMILY_HH
