#include "MarkerConfig.hh"
#include "ZUtils.hh"

#ifdef HAVE_ZLIB
const unsigned int MarkerConfig::BLOCK = 1 << 31;

void MarkerConfig::write(gzFile &out) {
  writeMap(out, m_affecteds_assignments);
  writeMap(out, m_founders_assignments);
  writeMap(out, m_blocks);
}

void MarkerConfig::writeMap(gzFile &out,
                            const map<vector<unsigned int>, unsigned int>  &m) {
  ::write(out, m.size());
  typedef map<vector<unsigned int>, unsigned int>::const_iterator MI;
  for (MI mi = m.begin(); mi != m.end(); mi++) {
    ::write(out, mi->first);
    ::write(out, mi->second);
  }
}

void MarkerConfig::writeMap(gzFile &out, const map<Block, unsigned int>  &m) {
  ::write(out, m.size());
  typedef map<Block, unsigned int>::const_iterator MI;
  for (MI mi = m.begin(); mi != m.end(); mi++) {
    write(out, mi->first);
    ::write(out, mi->second);
  }
}

void MarkerConfig::write(gzFile &out, const Block &b) {
  ::write(out, b.m_founders1, true);
  ::write(out, b.m_founders2, true);
  ::write(out, b.m_a1);
  ::write(out, b.m_a2);
}
#endif
