#ifndef _MARKERCONFIG_HH
#define _MARKERCONFIG_HH

#include <vector>
#include <map>
#include <string>

#ifdef HAVE_ZLIB
#include <zlib.h>

using namespace std;

class MarkerConfig {
  friend class ExtFamily;
public:
  static const unsigned int BLOCK;

  /// Output constructor
  MarkerConfig() {}
  
  /// 
  unsigned int addAffectedsAssignment(const vector<unsigned int> &aa) {
    map<AffectedsAssignment, unsigned int>::const_iterator ai =
      m_affecteds_assignments.find(aa);
    if (ai == m_affecteds_assignments.end())
      return m_affecteds_assignments[aa] = m_affecteds_assignments.size() - 1;
    else
      return ai->second;
  }

  ///
  unsigned int addBlock(const vector<unsigned int> &b1,
                        const vector<unsigned int> &b2,
                        unsigned int a1, unsigned int a2) {
    Block block(b1, b2, a1, a2);
    map<Block, unsigned int>::const_iterator bi = m_blocks.find(block);
    if (bi == m_blocks.end())
      return m_blocks[block] = m_blocks.size() - 1 | BLOCK;
    else
      return bi->second;
  }

  ///
  unsigned int addFoundersAssignment(const vector<unsigned int> &fa) {
    map<FoundersAssignment, unsigned int>::const_iterator fi =
      m_founders_assignments.find(fa);
    if (fi == m_founders_assignments.end()) {
      unsigned int &f = m_founders_assignments[fa];
      return f = m_founders_assignments.size() - 1;
    } else
      return fi->second;
  }

  void write(gzFile &m_out);

protected:
  class Block {
  public:
    Block() {}
    Block(const vector<unsigned int> &b1,
          const vector<unsigned int> &b2,
          unsigned int a1, unsigned int a2) :
        m_founders1(b1), m_founders2(b2), m_a1(a1), m_a2(a2) {}

    vector<unsigned int> m_founders1;
    vector<unsigned int> m_founders2;
    unsigned int m_a1;
    unsigned int m_a2;

    double m_prob1;
    double m_prob2;

    friend bool operator<(const Block &b1, const Block& b2) {
      if (b1.m_a1 < b2.m_a1) return true;
      else if (b1.m_a1 == b2.m_a1) {
        if (b1.m_a2 < b2.m_a2) return true;
        else if (b1.m_a2 == b2.m_a2) {
          if (b1.m_founders1 < b2.m_founders1) return true;
          else if (b1.m_founders1 == b2.m_founders1)
            return b1.m_founders2 < b2.m_founders2;
        }
      }
      return false;
    }

  };

  typedef vector<unsigned int> AffectedsAssignment;
  typedef vector<unsigned int> FoundersAssignment;

  // These are set for output
  map<AffectedsAssignment, unsigned int> m_affecteds_assignments;
  map<FoundersAssignment, unsigned int> m_founders_assignments;
  map<Block, unsigned int> m_blocks;
  
  void writeMap(gzFile &out, const map<vector<unsigned int>, unsigned int> &m);
  void writeMap(gzFile &out, const map<Block, unsigned int> &m);
  void write(gzFile &out, const MarkerConfig::Block &b);

};
#endif

#endif // _MARKERCONFIG_HH
