#ifndef _ZUTILS_HH
#define _ZUTILS_HH

#include <vector>
#ifdef HAVE_ZLIB
#include <zlib.h>

using namespace std;

// Output
inline void write(gzFile &out, unsigned int x) {
  gzwrite(out, &x, sizeof(unsigned int));
}

inline void write(gzFile &out, const string &s) {
  write(out, s.length());
  gzputs(out, s.c_str());
}

inline void write(gzFile &out, const vector<unsigned int> &v,
           bool write_size = false) {
  if (write_size) write(out, v.size());
  for (unsigned int i = 0; i < v.size(); i++) write(out, v[i]);
}

inline void write(gzFile &out, const vector<string> &v,
           bool write_size = false) {
  if (write_size) write(out, v.size());
  for (unsigned int i = 0; i < v.size(); i++) write(out, v[i]);
}

inline void write(gzFile &out, unsigned char x) {
  gzputc(out, x);
}

inline void write(gzFile &out, bool x) {
  gzputc(out, x);
}

// Input
inline void read(gzFile &in, unsigned int &x) {
  gzread(in, &x, sizeof(unsigned int));
}

inline void read(gzFile &in, unsigned char &x) {
  x = gzgetc(in);
}

inline void read(gzFile &in, string &s) {
  unsigned int length;
  read(in, length);
  s = "";
  for (unsigned int i = 0; i < length; i++) {
    unsigned char next_char;
    read(in, next_char);
    s += next_char;
  }
}

inline void read(gzFile &in, vector<unsigned int> &v,
           bool read_size = false) {
  unsigned int n;
  if (read_size) {
    read(in, n);
    v.resize(n);
  } else n = v.size();
  for (unsigned int i = 0; i < v.size(); i++) read(in, v[i]);
}

inline void read(gzFile &in, vector<string> &v,
           bool read_size = false) {
  unsigned int n;
  if (read_size) {
    read(in, n);
    v.resize(n);
  } else n = v.size();
  for (unsigned int i = 0; i < v.size(); i++) read(in, v[i]);
}

inline void read(gzFile &in, bool &x) {
  x = gzgetc(in);
}
#endif

#endif // _ZUTILS_HH
