#include "files.h"
#include "options.h"
#include "control.h"

#include "model.h"
#include <time.h>

#ifdef SET_PROC_DATA_SIZE
#include <sys/time.h>
#include <sys/resource.h>
#endif // SET_PROC_DATA_SIZE

#ifndef VERSION
#define VERSION ""
#endif // VERSION

void usage() {
  cerr << "Allegro " << PACKAGE_VERSION << endl << endl;
  cerr << "Usage:\tallegro [ -l <logfile> ] [-t] [-n] [-m] <optionsfile>"
       << endl;
  exit(1);
}

int alle_optind = 1;

int alle_getopt(int argc, char *argv[], const char *mask) {
  char buf[3] = "-?";
  if (argc <= alle_optind || argv[alle_optind][0] != '-') return -1;
  for (Uint i = 0; i < strlen(mask); i++) {
    buf[1] = mask[i];
    if (strcmp(buf, argv[alle_optind]) == 0) {
      alle_optind++;
      return mask[i];
    }
  }
  alle_optind++;
  return '?';
}

int main(int argc, char* argv[]) {
  ios::sync_with_stdio(false);
  
#ifdef SET_PROC_DATA_SIZE
  rlimit pLimit;
  getrlimit(RLIMIT_DATA, &pLimit);
  pLimit.rlim_cur = pLimit.rlim_max;
  setrlimit(RLIMIT_DATA, &pLimit);
  getrlimit(RLIMIT_DATA, &pLimit);
#endif //SET_PROC_DATA_SIZE
  
  time_t starttime, endtime;
  time(&starttime);
  int c;
  string logfilename = "allegro.log";
  bool lflag = false;
  bool nflag = false;
  bool tflag = false;
  bool mflag = false;
  while ((c = alle_getopt(argc, argv, "tnl:m")) != -1) {
    switch (c) {
      case 'l':
        if (nflag) usage();
        logfilename = argv[alle_optind++];
        lflag = true; break;
      case 'n':
        if (lflag || tflag) usage();
        nflag = true; break;
      case 't':
        if (nflag) usage();
        tflag = true; break;
      case 'm':
        mflag = true; break;
      default: usage();
    }
  }
  if (argc <= alle_optind) usage();
  if (nflag) logfile = 0;
  else if (tflag)
    logfile = new ofstream(logfilename.c_str(), ios::out | ios::trunc);
  else 
    logfile = new ofstream(logfilename.c_str(), ios::out | ios::app);
  message(string("Allegro ") + VERSION + " - fast multipoint linkage analysis");
  message("");
  options = new Options(argv[alle_optind]);

  Model::printmodels();
  message("");

  if (mflag) options->estimatememory = true;
  control = new Control;
  if (options->skipfirstphase && options->readprobfiles) {
    control->readprobfiles();
    Model::modeloutput();
  }
  else
    control->probs();
  time(&endtime);
  endtime -= starttime;
  char buf[30];
  strftime(buf, 30, "%X", gmtime(&endtime));
  message(string("Run completed in ") + buf);
  exit(0);
}
