#ifndef _ASMEXP
#define _ASMEXP
#include "basic.h"

class Convolver;
class Calcscore;

class ASMexp : public ASMmodel {
  friend Double f_exp(Double, Uint);
  friend Double f_delta(Double delta, Double &lod, Double &npl);
public:
  ASMexp(Calcscore *sc, const string &pt);
  virtual ~ASMexp() {}
protected:
  // For exact p-value calculations
  static const Uint ndelta = 10001;
  DoubleVec lodp;
  DoubleVec lodpi;
  DoubleVec nplpi;

  void exactp();
  void calclodps(const Convolver &cv, Double leftbound, Double rightbound);
  Double calclodpvalue(Double x) const;

  // Results of multipoint calculations
  UintVec nscores;
  DoubleMat *nullprob;
  DoubleMat value;
  DoubleMat *prob;
  DoubleMat *zscore;
  
  virtual void initialize();
  virtual void cleanup();
  virtual void run();
  void compute_wnpl();
  Double RIp(Uint pos) const;
  Double RIf(Uint pos) const;
  void allegroexponential();
  void allegroexpinfo() const;
  virtual void compute_fam_info() const;

  virtual void printfaminfo() const;

};

#endif // _AASM
