#ifndef _ASMODEL
#define _ASMODEL
#include "output.h"
#include "model.h"

class Modelweight;
class Entropy;

class ASMmodel : public Model {
public:
  ASMmodel(const string &pt, const string &mo);
  virtual ~ASMmodel();

  virtual void output();
  void print() const;
  void setweights(Modelweight *mw) {modelweight = mw;}
  void setupfiles(const string &outfile, const string &foutfile);
protected:
  Outfile ioutfile;
  
  Modelweight *modelweight;
  string model;
  Entropy *entropy;

  DoubleVec dhat;
  DoubleVec zlr;
  DoubleVec npl;
  DoubleVec lod;
  DoubleMat information;
  DoubleMat flod;
  DoubleMat wnpl;
  DoubleMat faminfo;
  virtual void compute_fam_info() const = 0;

  DoubleMat nullmean;
  DoubleMat nullsd;
  DoubleMat weight;

  bool dolodexactp;
  bool donplexactp;
  DoubleVec nplexactps;
  DoubleVec lodexactps;

  void assignweights() const;

  virtual void printfaminfo() const = 0;

  virtual void initialize();
  void compute_final_stats();
  virtual void cleanup();
  virtual void run() = 0;
  virtual void totline(ostream &f, Uint pos);
  virtual void famline(ostream &f, Uint ifa, Uint pos);
  virtual void totheader(ostream &f);
  virtual void famheader(ostream &f);
};

#endif // _ASMODEL
