#ifndef _AASMPOLY
#define _AASMPOLY
#include "basic.h"
#include "output.h"
#include "model.h"

class Calcscore;

class ASMpoly : public ASMmodel {
public:
  ASMpoly(Calcscore *sc, const string &pt, const string &mo, Uint deg);
  virtual ~ASMpoly() {}

protected:
  // Results of multipoint calculations
  DoubleMat *zvalue;
  DoubleMat *znullvalue;
  Uint degree;

  DoubleVec minvalue;
  DoubleVec maxvalue;
  
  virtual void initialize();
  virtual void cleanup();
  virtual void run();
  void compute_fam_npl();
  virtual void compute_fam_info() const;
  static Double f_lin(Double x, Uint pos);
  void linearbounds(Double &dmin, Double &dmax) const;
  Double RIp(Uint pos) const;
  Double RIf(Uint pos) const;
  void allegroinfo() const;
  void allegrolinear();

  virtual void printfaminfo() const;

};

#endif // _AASMPOLY
