#ifndef _ASSOCDIST
#define _ASSOCDIST
#include "basic.h"
#include "distribution.h"
#include "vecutil.h"

class Calcassoc;
class Calcassocperson;

class Assocdist : public Distribution {
public:
  enum CorrectionType {RAW, FAMILY, LINKAGE};
  
  virtual ~Assocdist();
  virtual string describe() const
    {return string("assoc") + correctiontypetostring(corr);}
  
  static Assocdist *getassocdist(const string &pt, CorrectionType ct,
                                 Calcassoc *aw);

  DoubleMat getET(Uint ifam) {return familydata[ifam]->ET;}
  DoubleMat getET2(Uint ifam) {return familydata[ifam]->ET2;}
  DoubleMat getET3(Uint ifam) {return familydata[ifam]->ET3;}

  // Use all families that have more than 0 affected or unaffected people
  virtual bool usefamily(Family *fam) const;
protected:
  CorrectionType corr;

  static string correctiontypetostring(CorrectionType ct) {
    if (ct == RAW) return "";
    else if (ct == FAMILY) return "family";
    else if (ct == LINKAGE) return "linkage";
    else assertinternal(false);
  }
  
  Calcassoc *assocweight;
  Calcassocperson *first;
  
  Assocdist(const string &p, CorrectionType ct, Calcassoc *aw);

  class Familydata {
  protected:
    void init() {
      NEWVEC(DoubleVec, ET, nmrk);
      NEWVEC(DoubleVec, ET2, nmrk);
      NEWVEC(DoubleVec, ET3, nmrk);
      zero(ET, nmrk);
      zero(ET2, nmrk);
      zero(ET3, nmrk);
    }
    
  public:
    Familydata(Uint n) : nmrk(n) {
      init();        
    }
    Familydata(const Familydata &fd) : nmrk(fd.nmrk) {
      init();
    }
    ~Familydata() {
      for (Uint gam = 0; gam < nmrk; gam++) {
        DELETEVEC(ET[gam]);
        DELETEVEC(ET2[gam]);
        DELETEVEC(ET3[gam]);
      }
      DELETEVEC(ET);
      DELETEVEC(ET2);
      DELETEVEC(ET3);
    }

    Uint nmrk;
    DoubleMat ET;
    DoubleMat ET2;
    DoubleMat ET3;
  };
  
  friend class Assocdist::Familydata;
  typedef vector<Familydata *> Familydatavector;
  Familydatavector familydata;

//  bool hasinformativedescendants(Person *per) const;
  
  Double calcET(Uint gam, Uint a);
  
  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0);
  virtual void set(FloatVec pv, Uint pos);
  virtual void skipfam();

  virtual void writeprob(const Map &/*map*/) {}
  virtual void readprob(Infile& /*f*/) {}
  virtual void writenull() {}
  virtual void readnull(Infile& /*f*/) {}
};

#endif // _ASSOCDIST
