#ifndef _ASSOCMODEL
#define _ASSOCMODEL

#include "basic.h"

class Assocdist;
class Calcassoc;

class Assocmodel : public Model {
public:
  Assocmodel(const string &p, Double wa, Double wu, bool estfrq,
             const string &patfile, const string &ctrlfile,
             const string &outfile, const string &foutfile);
  Assocmodel(const string &p, const string &wf, bool estfrq,
             const string &patfile, const string &ctrlfile,
             const string &outfile, const string &foutfile);
  virtual ~Assocmodel();
  virtual void print() const;
  bool nolinkage() const;
protected:
  Calcassoc *aw;
  
  DoubleMat zscore_raw;
  DoubleMat *fzscore_raw;
  DoubleMat zscore_family;
  DoubleMat *fzscore_family;
  DoubleMat zscore_linkage;
  DoubleMat *fzscore_linkage;
//  DoubleMat kurtosis;

  Assocdist *distfamily;
  Assocdist *distlinkage;

  void initialize(DoubleMat &zscore, DoubleMat *&fzscore);
  void cleanup(DoubleMat &zscore, DoubleMat *&fzscore);
  void getresults(Assocdist *ad, DoubleMat zscore, DoubleMat *fzscore);
  Double calcT(Uint ifam, Uint gam, int allele) const;
  
  virtual void output();
  void lines(ostream &f, Uint ifa, bool famflag);
   virtual void totline(ostream &/*f*/, Uint /*pos*/) {assertinternal(false);}
  virtual void famline(ostream &f, Uint /*ifa*/, Uint /*pos*/)
     {assertinternal(false);}
  virtual void totline(ostream &f, Uint pos, Uint allele = 0);
  virtual void famline(ostream &f, Uint ifa, Uint pos, Uint allele = 0);
  virtual void totheader(ostream &f);
  virtual void famheader(ostream &f);
};

#endif // _ASSOCMODEL
