#include "basic.h"
#include "warning.h"

void *operator new(size_t size) throw(bad_alloc) {
  assertinternal(size > 0);
  if (void *p = malloc(size)) return p;
  else {
    fatal(string("Out of memory. If all calculations are in memory try using ") +
          "MAXMEMORY.");
  }
}

void *operator new[](size_t size) throw(bad_alloc) {
  assertinternal(size > 0);
  if (void *p = malloc(size)) return p;
  else {
    fatal(string("Out of memory. If all calculations are in memory try using ") +
          "MAXMEMORY.");
  }
}

#ifdef CHECKMEMORY
vector<Double *> DoubleVec::allocated;
//vector<Float *> FloatVec::allocated;
vector<int *> IntVec::allocated;
vector<Uint *> UintVec::allocated;
//vector<IV *> IVVec::allocated;
vector<string *> StringVec::allocated;
vector<bool *> BoolVec::allocated;

vector<DoubleVec *> DoubleMat::allocated;
//vector<FloatVec *> FloatMat::allocated;
vector<IntVec *> IntMat::allocated;
vector<UintVec *> UintMat::allocated;
//vector<IVVec *> IVMat::allocated;

//  vector<DoubleMat *> DoubleMat3::allocated;
//  //vector<FloatMat *> FloatMat3::allocated;
//  vector<IntMat *> IntMat3::allocated;
//  vector<UintMat *> UintMat3::allocated;
//  //vector<IVMat *> IVMat3::allocated;
#endif // CHECKMEMORY
