#ifndef _BFGS
#define _BFGS
#include "basic.h"

class BFGS {
public:
  typedef Double(*Trianglefunction)(DoubleVec x, Uint pos);
  BFGS(
    Uint mxit,           // maximum iteration count
    Uint ndims,          // number of dimensions (currently should be 2 or 3)
    Uint nconstr,        // number of constraints of search region
    Double geps,         // epsilon used for numerical gradient (~1d-8)
    Double ceps,         // epsilon used for convergence (~1d-5)
    Double sig,          // exactness of linesearch (0.9)
    bool cent);          // true for central difference numerical gradients
  ~BFGS();
  void minimize(DoubleVec x0, DoubleVec x1, Double &y1,
                Uint positn, Trianglefunction fun);
  void addconstraint(DoubleMat c);
  void addconstraint(DoubleVec a, Double bb);
  
protected:
  const Uint maxit;
  const Uint n;
  const Uint nconstraints;
  Uint nsetconstraints;
  Uint pos, nactive, nred;
  Double gradeps, conveps, sigma, eps;
  bool central;
  DoubleMat B, A, Z, Zold, W;
  BoolVec active;
  Trianglefunction fun;
  DoubleVec b;
  UintVec iact; // active constraints
  Uint nfun, ngrad;
  Double callfun(DoubleVec x) {nfun++; return fun(x, pos);}
  template<class T> T min(T x, T y) {if (x < y) return x; else return y; }
  void chol(DoubleMat C, DoubleVec x, DoubleVec b, Uint n); // solve B*x = b with Choleski
  void householder(DoubleMat Z, Uint firstcol, Uint ncol);
  void findlambda(DoubleVec lambda, DoubleVec g);
  void r1update(DoubleMat A, DoubleVec x, Double a, Uint n);
  void numgrad(DoubleVec g, DoubleVec x, Double f);
  bool posturn(DoubleVec s, DoubleVec x, DoubleVec c);
  void findsearchdir(DoubleVec s, DoubleVec g, DoubleVec p, DoubleVec Ztg);
  void addconstraint(Uint i);
  void removeconstraint(Uint q);
  void checkintegrity() const;
  Double maxstep(DoubleVec x, DoubleVec s, int &imax);
  Double linesearch(DoubleVec s, DoubleVec x, Double f, DoubleVec g, Double &f1, 
                    DoubleVec g1, int &imax);

  bool linesearchcond(Double f, Double f1, Double d, Double d1) const
    {return f1 < f && fabs(d1) < sigma*fabs(d);}
  static bool bracketcond(Double f0, Double f1, Double d1)
    {return f1 > f0 || d1 > 0;}
};

#endif
