#include "calc.h"
#include "family.h"
#include "utils.h"

/////////////////////////////////////////////////////////////////////////
// Calc

Calc::Calcvector Calc::calcs;

void Calc::calcnumscores(Family *first, IV maxnumiv) {
  numscores = 0;
  for (Family *f = first; f != 0; f = f->next) {
    Uint numas = f->nasymmetricfoundercouples();
    if (numscores == 0) numscores = maxnumiv;
    numscores = max_(f->numiv*POW2[numas], numscores);
  }
}

Calc *Calc::findcalc(const string &desc) {
  for (Uint s = 0; s < calcs.size(); s++)
    if (calcs[s]->describe() == desc)
      return calcs[s];
  return 0;
}

Double Calc::countvecsneeded(Family *first, IV maxnumiv) {
  Double count = 0.0;
  for (Uint s = 0; s < calcs.size(); s++)
    calcs[s]->calcnumscores(first, maxnumiv);
  for (Uint s = 0; s < calcs.size(); s++)
    count += Double(calcs[s]->numscores)/Double(maxnumiv);
  return count;
}

void Calc::reset(Family *first, IV maxnumiv) {
  for (Uint s = 0; s < calcs.size(); s++) {
    DELETEVEC(calcs[s]->vec);
    calcs[s]->calcnumscores(first, maxnumiv);
    if (calcs[s]->numscores > 0)
      NEWVEC(Double, calcs[s]->vec, calcs[s]->numscores);
    calcs[s]->res(first, maxnumiv);
  }
}

void Calc::calculate(Family *fam) {
  if (fam->numbits > 0) 
    for (Uint s = 0; s < calcs.size(); s++)
      (*calcs[s])(fam);
}
