#include "calcassoc.h"
#include "control.h"
#include "files.h"
#include "map.h"
#include "vecutil.h"
#include "fmtout.h"

///////////////////////////////////////////////////////////////////////////
// Calcassoc
Calcassoc::Calcassoc(bool estfrq) : Calc("assocweight"), estimatefreq(estfrq) {}

Calcassoc::~Calcassoc() {
  deletepi();
}

void Calcassoc::deletepi() {
  while (pi.size() > 0) {
    DELETEVEC(pi.back());
    pi.pop_back();
  }
}

void Calcassoc::res(Family *first, IV /*maxnumiv*/) {
  if (estimatefreq) {
    deletepi();
    pi.resize(control->map.num, 0);
  }

  affA.resize(control->map.num, 0);
  affn.resize(control->map.num, 0);
  contA.resize(control->map.num, 0);
  contn.resize(control->map.num, 0);
  for (Uint gam = 0; gam < control->map.num; gam++) {
    String2Double pns;
    NEWVEC(Uint, affA[gam], control->map.numallele[gam]);
    zero(affA[gam], control->map.numallele[gam]);
    NEWVEC(Uint, contA[gam], control->map.numallele[gam]);
    zero(contA[gam], control->map.numallele[gam]);
    for (Family *fam = first; fam != 0; fam = fam->next)
      for (Person *p = fam->first; p != 0; p = p->next)
        if (p->genotyped && p->genotyp[gam]) {
          Double w = assign(p, gam);
          if (w > 0) {
            affA[gam][p->gen[0][gam] - 1]++;
            affA[gam][p->gen[1][gam] - 1]++;
            affn[gam]++;
          }
          else if (w < 0) {
            contA[gam][p->gen[0][gam] - 1]++;
            contA[gam][p->gen[1][gam] - 1]++;
            contn[gam]++;
          }
        }
    if (estimatefreq) {
      NEWVEC(Float, pi[gam], control->map.numallele[gam]);
      zero(pi[gam], control->map.numallele[gam]);
      if (affn[gam] + contn[gam] > 0)
        for (Uint a = 0; a < control->map.numallele[gam]; a++)
          pi[gam][a] =
            (affA[gam][a] + contA[gam][a])/2.0/(affn[gam] + contn[gam]);
    }
  }
}

FloatVec Calcassoc::getfreq(Uint gam) {
  if (estimatefreq) return pi[gam];
  else return control->map.pi[0][gam];
}

//////////////////////////////////////////////////////////////////////////
// Calcassocsimple
string Calcassocsimple::describe() const {
  return  Calcassoc::describe() + "waff:" + Floattostring(waff, 2) +
    " wunaff:" + Floattostring(wunaff, 2);
}

///////////////////////////////////////////////////////////////////////////
// Calcassocfile
Calcassocfile::Calcassocfile(bool estfrq, const string &file) :
    Calcassoc(estfrq), filename(file) {
  Infile wtsfile;
  wtsfile.setname(filename);
  wtsfile.optcheck("Association weight file");
  wtsfile.open();
  while (!wtsfile.eof()) {
    string pn;
    Double weight;
    wtsfile >> pn >> weight;
    weights[pn] = weight;
    optassert(wtsfile.good() || wtsfile.eof(),
              "Illegal format of association weight file " + filename);
  }
  wtsfile.close();
}

///////////////////////////////////////////////////////////////////////////
// Calcassocfrac
void Calcassocfrac::res(Family *first, IV maxnumiv) {
  weights.clear();
  weights.resize(control->map.num);
  for (Uint gam = 0; gam < control->map.num; gam++) {
    for (Family *fam = first; fam != 0; fam = fam->next)
      for (Person *p = fam->first; p != 0; p = p->next)
        if (p->genotyped && p->genotyp[gam])
          if (p->origdstat == AFFECTED) weights[gam][p->id]++;
          else if (p->origdstat == UNAFFECTED) weights[gam][p->id]--;
    Double naff = 0.0;
    Double nunaff = 0.0;
    for (String2Double::const_iterator i = weights[gam].begin();
         i != weights[gam].end(); i++)
      if (i->second < 0) nunaff++;
      else if (i->second > 0) naff++;
    if (naff == 0.0)
      warning("No affecteds genotyped at " + control->map.markername[gam] +
              " so that fraction of alleles can not be used in association");
    else if (nunaff == 0.0)
      warning("No unaffecteds genotyped at " + control->map.markername[gam] +
              " so that fraction of alleles can not be used in association");
    for (String2Double::iterator i = weights[gam].begin();
         i != weights[gam].end(); i++)
      if (naff > 0 && nunaff > 0) {
        if (i->second < 0) i->second = 1.0/nunaff/i->second;
        else if (i->second > 0) i->second = 1.0/naff/i->second;
      }
      else i->second = 0.0;
  }
  Calcassoc::res(first, maxnumiv);
}
