#ifndef _CALCASSOC
#define _CALCASSOC
#include "basic.h"
#include "calc.h"
#include "family.h"

class Calcassocperson;

class Calcassoc : public Calc {
public:
  Calcassoc(bool estfrq);
  virtual ~Calcassoc();
  virtual Double assign(Person *per, Uint gam) = 0;
  virtual void res(Family *first, IV maxnumiv);
  FloatVec getfreq(Uint gam);
  virtual string describe() const {return estimatefreq ? "" : "datfreq";}

  Uint getaffA(Uint gam, Uint a) {return affA[gam][a];}
  Uint getaffa(Uint gam, Uint a) {return 2*affn[gam] - affA[gam][a];}
  Uint getcontA(Uint gam, Uint a) {return contA[gam][a];}
  Uint getconta(Uint gam, Uint a) {return 2*contn[gam] - contA[gam][a];}
private:
  bool estimatefreq;
  vector<FloatVec> pi;

  void deletepi();
protected:
  vector<UintVec> affA;
  vector<Uint> affn;
  vector<UintVec> contA;
  vector<Uint> contn;
  
  virtual void calcnumscores(Family */*first*/, IV /*maxnumiv*/)
    {numscores = 0;}
  virtual void operator() (Family *) {}
};

class Calcassocsimple : public Calcassoc {
protected:
  Double waff;
  Double wunaff;
public:
  Calcassocsimple(bool estfrq, Double wa, Double wu) :
      Calcassoc(estfrq), waff(wa), wunaff(wu) {}
  virtual Double assign(Person *per, Uint gam) {
    if (!per->genotyped || !per->genotyp[gam]) return 0.0;
    if (per->origdstat == AFFECTED) return waff;
    else if (per->origdstat == UNAFFECTED) return wunaff;
    else return 0.0;
  }
  virtual string describe() const;
};

class Calcassocfile : public Calcassoc {
protected:
  String2Double weights;
  string filename;
public:
  Calcassocfile(bool estfrq, const string &file);
  virtual string describe() const
    {return Calcassoc::describe() + " " + filename;}
  virtual Double assign(Person *per, Uint gam) {
    if (per->genotyped && per->genotyp[gam])
      return weights[per->id];
    else return 0.0;
  }
};

class Calcassocfrac : public Calcassoc {
protected:
  typedef vector<String2Double> weightlist;
  weightlist weights;
public:
  Calcassocfrac(bool estfrq) : Calcassoc(estfrq) {}
  
  virtual string describe() const {return Calcassoc::describe() + " " ;}
  virtual void res(Family *first, IV maxnumiv);
  virtual Double assign(Person *per, Uint gam) {
    if (per->genotyped && per->genotyp[gam])
      return weights[gam][per->id];
    else return 0.0;
  }
};

#endif // _CALCASSOC
