#include "calcmarker.h"
#include "probability.h"
#include "singlelocus.h"
#include "files.h"
#include "options.h"
#include "control.h"
#include "vecutil.h"

/////////////////////////////////////////////////////////////////////
// Calcmarker

Calcmarker *Calcmarker::getcalcmarker(const string &markerid, bool sexl) {
  Calc *clc = findcalc(description(markerid, sexl));
  if (clc != 0) return (Calcmarker *)clc;
  else return new Calcmarker(markerid, sexl);
}

void Calcmarker::operator() (Family *fam) {
  if (options->sexlinked == getsexlinked()) {
    FloatVec freq;
    control->getmarkerallelefreq(marker, freq);
    Uint midx = control->getmarkerindex(marker);
    Probability::fromhere(midx, vec, freq, fam);
    DELETEVEC(freq);
  }
}
