#ifndef _CALCMARKER
#define _CALCMARKER
#include "calclinkage.h"

class Calcmarker : public Calclinkage {
protected:
  // The probability of every inheritance vector is stored in vec
  string marker;
  bool sexlinked;
  
  Calcmarker(const string &markerid, bool sexl) :
      Calclinkage("marker"),
      marker(markerid), sexlinked(sexl) {}
  static string description(const string &marker, bool sexlinked)
    {return "marker:" + marker + (sexlinked ? " X" : "");}
  
public:
  virtual bool getsexlinked() const {return sexlinked;}

  static Calcmarker *getcalcmarker(const string &markerid, bool sexl);
  virtual void operator() (Family *fam);
  string getmarkerid() const {return marker;}
  virtual string describe() const
    {return description(marker, sexlinked);}
};

#endif // _CALCMARKER
