#include "calcparametric.h"
#include "files.h"
#include "peel.h"
#include "vecutil.h"
#include "options.h"

//////////////////////////////////////////////////////////////////////
// Calcparametric

Calcparametric *Calcparametric::getcalcparametric(Trait *tr) {
  Calc *clc = findcalc(description(tr));
  if (clc != 0) return (Calcparametric *)clc;
  else return new Calcparametric(tr);
}

void Calcparametric::calclod(Family *fam, Foundercouple *fc) {
  if (fc == 0) {
    ESgraph g = ESgraph(*fam, trait);
    g.peel(vec);
  }
  else {
    calclod(fam, fc->next);
    if (fc->husband->dstat != fc->wife->dstat) {
      fc->swapdstat();
      calclod(fam, fc->next);
      fc->swapdstat();
    }
  }
}

void Calcparametric::operator() (Family *fam) {
  if (options->sexlinked == getsexlinked()) {
    zero(vec, fam->numiv);
    calclod(fam, fam->firstfoundercouple);
  }
}
