#ifndef _CALCPARAMETRIC
#define _CALCPARAMETRIC
#include "calclinkage.h"
#include "trait.h"

class Foundercouple;

class Calcparametric : public Calclinkage {
protected:
  // The likelihood of every inheritance vector is stored in vec
  Trait *trait;
  
  void calclod(Family *fam, Foundercouple *fc);
  Calcparametric(Trait *tr) :
      Calclinkage("par"), trait(tr) {}

  static string description(Trait *tr)
    {return string("par") + (tr == 0 ? "" : " " + tr->describe());}
public:
  virtual bool getsexlinked() const
    {return trait == 0 ? false : trait->getsexlinked();}
//    string getfreq() const {return trait == 0 ? "default" : trait->getfreq();}
//    string getpenetrances() const
//      {return trait == 0 ? "default" : trait->getpenetrances();}
  Trait *gettrait() {return trait;}
  static Calcparametric *getcalcparametric(Trait *tr);
  virtual void operator() (Family *fam);
  void settrait(Trait *tr) {assertinternal(trait == 0); trait = tr;}
  virtual string describe() const {return description(trait);}
};

#endif // _CALCPARAMETRIC
