#include "calcqtl.h"

CalcQTL::CalcQTL(const string &cid, Double s2, Double s, Double g, Double d) :
    Calcscore(cid), sigma2(s2), shared(s), sigma2_g(g), sigma2_d(d) {}

CalcQTL *CalcQTL::getcalcQTL(const string &cid, Double s2, Double s, Double g,
                             Double d) {
  optassert(s > 0, "Shared variance component must be greater than 0");
  Calc *clc = findcalc(description(cid, s2, s, g, d));
  if (clc != 0) return (CalcQTL *)clc;
  else return new CalcQTL(cid, s2, s, g, d);
}

void CalcQTL::operator() (Family *fam) {
  loglik.calc(fam, vec, sigma2, shared, sigma2_g, sigma2_d);
  if (id == "qtlfamilyncp") {
    Double fac = 0.0;
    for (IV v = 0; v < fam->numiv; v++) {
      vec[v] = exp(vec[v]);
      fac += vec[v];
    }
    fac /= Double(fam->numiv);
    for (IV v = 0; v < fam->numiv; v++)
      vec[v] /= fac;
  }
}
