#ifndef _CALCQTL
#define _CALCQTL
#include "basic.h"
#include "calc.h"
#include "calcscore.h"
#include "findnormal.h"

class CalcQTL : public Calcscore {
protected:
  Double sigma2;
  Double shared;
  Double sigma2_g;
  Double sigma2_d;
  FindNormalLoglik loglik;

  CalcQTL(const string &cid, Double s2, Double s, Double g, Double d);
  static string description(const string &cid, Double /*s2*/, Double s,
                            Double g, Double d)
    {return cid + " vc:" + Floattostring(s, 6) + "/" + Floattostring(g, 6) +
       "/" + Floattostring(d, 6);}
  void setupscorefamily(Family */*fam*/) {}
  void calc(DoubleVec , Family */*fam*/) {}
public:
  static CalcQTL *getcalcQTL(const string &cid, Double s2, Double s,
                             Double g, Double d = -1);
  virtual void operator() (Family *fam);
  virtual bool isdiscrete() const {return false;}
};

#endif // _CALCQTL
