#ifndef _CALCSCORE
#define _CALCSCORE
#include "calc.h"
#include "fmtout.h"
#include "files.h"

class Scoreperson;
class Foundercouple;

class Calcscore : public Calc {
protected:
  virtual void setupscorefamily(Family *fam) = 0;
  void calcscore(Foundercouple *fc, Uint &i, Family *fam);
  virtual void calc(DoubleVec score, Family *fam) = 0;
  Calcscore(const string &sc) : Calc(sc) {}
public:
  virtual bool isdiscrete() const = 0;
  virtual void operator() (Family *fam);
  virtual void printpairscores(Family */*fam*/) {}
};

class Calcqualitativescore : public Calcscore {
protected:
  Scoreperson *firstdesc;
  Scoreperson *first;
  virtual void setupscorefamily(Family *fam);
  virtual void calc(DoubleVec score, Family *fam);
  Calcqualitativescore(const string &sc) : Calcscore(sc) {}
public:
  virtual bool isdiscrete() const {return true;}
  static Calcqualitativescore *getcalcqualitativescore(const string &sc);
};

class Calcparentspecificscore : public Calcqualitativescore {
protected:
  Double w_mm;
  Double w_mf;
  Double w_ff;
  
  Calcparentspecificscore(const string &sc, Double wmm, Double wmf,
                          Double wff) :
      Calcqualitativescore(sc), w_mm(wmm), w_mf(wmf), w_ff(wff) {}
  virtual void calc(DoubleVec score, Family *fam);
  static string description(const string &sc,
                            Double wmm, Double wmf, Double wff) {
    return sc + " " + Floattostring(wmm, 2) + " " + Floattostring(wmf, 2) +
      " " + Floattostring(wff, 2);
  }
public:
  virtual bool isdiscrete() const {return false;}
  virtual string describe() const {return description(id, w_mm, w_mf, w_ff);}
  static Calcparentspecificscore *getcalcparentspecificscore(const string &sc,
                                                             Double wmm,
                                                             Double wmf,
                                                             Double wff);
  virtual void operator() (Family *fam);
};

class Genpairsperson;

class Calcgenpairs : public Calcscore {
protected:
  Outfile pairscores;
  Genpairsperson *first;
  String2Bool informative;
  String2Double pair2weight1;
  String2Double pair2weight2;

  string pair2string(const string &a, const string &b) const;
  virtual void setupscorefamily(Family *fam);
  virtual void calc(DoubleVec score, Family *fam);
  Calcgenpairs(const string &sc);
public:
  virtual bool isdiscrete() const {return false;}
  virtual void printpairscores(Family *fam);
};


class Calcgenpairsfile : public Calcgenpairs {
protected:
  string filename;
  
  Calcgenpairsfile(const string &sc, const string &fn);
  
public:
  static Calcgenpairsfile *getcalcgenpairsfile(const string &sc,
                                               const string &fn);
  virtual string describe() const {return id + " " + filename;}
  virtual void operator() (Family *fam);
};

class Calcgenpairsshared : public Calcgenpairs {
protected:
  Double shared;
  Double variance;
  
  Float calcweight(Float ks, Float x1, Float x2);
  Calcgenpairsshared(const string &sc, Double shr, Double var) :
      Calcgenpairs(sc), shared(shr), variance(var) {}
  static string description(const string &cid, Double shr, Double var) 
    {return cid + " " + Floattostring(shr, 2) +
       (var == 1 ? "" : " " + Floattostring(var, 2));}
public:
  static Calcgenpairsshared *getcalcgenpairsshared(const string &sc, Double s,
                                                   Double v);
  virtual void operator() (Family *fam);
  virtual string describe() const {return description(id, shared, variance);}
};
  
class FindIBD;

class Calcgenpairsvc : public Calcgenpairs {
protected:
  Double shared;
  Double sigma2_g;
  Double sigma2_d;
  static FindIBD *findIBD;
  
  void calcweight(Float p1, Float p2, Float x1, Float x2, Float &w1, Float &w2);
  Calcgenpairsvc(const string &sc, Double s, Double a, Double d) :
      Calcgenpairs(sc), shared(s), sigma2_g(a), sigma2_d(d) {}
  static string description(const string &id, Double s, Double a, Double d) 
    {return id + " " + Floattostring(s, 2) +  " " + Floattostring(a, 2) + " " +
       Floattostring(d, 2);}
  Float probpair(Float ks, Float x1, Float x2, Float pi);
public:
  static Calcgenpairsvc *getcalcgenpairsvc(const string &sc, Double s2,
                                           Double s, Double a, Double d);
  virtual void operator() (Family *fam);
  virtual string describe() const
    {return description(id, shared, sigma2_g, sigma2_d);}
};


#endif // _CALCSCORE
