#include "calcviterbi.h"
#include "control.h"
#include "options.h"

vector<IVVec> Calcviterbi::buffers;
vector<Uint> Calcviterbi::buffersize;

Calcviterbi *Calcviterbi::getcalcviterbi(const string &s) {
  Calc *clc = findcalc(s);
  if (clc == 0) clc = new Calcviterbi(s);
  return (Calcviterbi *)clc;
}

void Calcviterbi::res(Family */*first*/, IV maxnumiv) {
  if (!psibufborrowed) DELETEVEC(psibuf);
  delete psi;
  Uint n = Uint(options->swap ? Double(maxnumiv) :
                Double(control->map.num)*Double(maxnumiv));
  if (n == 0) n = 1;
  psibuf = getbuf(n);
  psibufborrowed = psibuf != 0;
  if (!psibufborrowed) NEWVEC(IV, psibuf, n);
  psi = new IVmatrix(psibuf, n, options->swapdirname, "psi." + id + ".");
}

void Calcviterbi::registerbuf(IVVec buf, Uint n) {
  buffers.push_back(buf);
  buffersize.push_back(n);
}

void Calcviterbi::resetbufs() {
  buffers.clear();
  buffersize.clear();
}

IVVec Calcviterbi::getbuf(Uint n) {
  assertinternal(buffers.size() == buffersize.size());
  Uint i = 0;
  while (i < buffersize.size() && buffersize[i] < n)
    i++;
  if (i < buffers.size()) {
    buffersize[i] = 0;
    return buffers[i];
  }
  else return 0;
}
