#ifndef _CALCVITERBI
#define _CALCVITERBI
#include "calc.h"
#include "basic.h"
#include "matrix.h"

// A class that allocates memory for Viterbi algorithms. Note that it
// performs no calculations.
// The vec variable will hold the "delta" buffer and the psibuf variable
// will hold the "psi" buffer.
class Calcviterbi : public Calc {
public:
  ~Calcviterbi() {DELETEVEC(psibuf);}
  virtual void operator() (Family */*fam*/) {}

  IVmatrix *psi;

  // Allows buffers that are used in sweap from left to be used in Viterbi
  // calculations
  static void registerbuf(IVVec buf, Uint n);
  static void resetbufs();

  static Calcviterbi *getcalcviterbi(const string &cid);
protected:
  IVVec psibuf;
  bool psibufborrowed;
  static vector<IVVec> buffers;
  static vector<Uint> buffersize;
  static IVVec getbuf(Uint n);

  void calcnumscores(Family *, IV maxnumiv) {numscores = maxnumiv;}
  virtual void res(Family *first, IV maxnumiv);
  Calcviterbi(const string &cid) : psi(0), Calc(cid), psibuf(0) {}
};

#endif // _CALCVITERBI
