#include "files.h"
#include "calcqtl.h"
#include "condlikmodel.h"
#include "inherdist.h"
#include "fmtout.h"

//////////////////////////////////////////////////////////////////////
// Condlikmodel
Condlikmodel::Condlikmodel(const string &p, bool maxG, bool maxA, bool maxD,
                           Double shr, const string &of, const string &fof) :
    QTLmodel(p, true, maxG, maxA, maxD, shr) {
  distribution = Inherdist::getinherdist(pt);
  setfiles(of, fof, string("condlik.") + shr + "." + pt,
           "Conditional likelihood output");
}

void Condlikmodel::print() const {
  string out = "MODEL condlik " + pt + " ";
  out += "shared:" + (maximizeG ? "max" : Floattostring(shared, 2)) + " ";
  message(out + outfile.name + " " + foutfile.name);
}
