#ifndef _CONTROL
#define _CONTROL
#include "basic.h"
#include "matrix.h"
#include "map.h"

class Probability;

class Marker;
class Chromosome;
class PN;

typedef hash_map<int, int> Int2int;
typedef hash_map<int, Float> Int2float;
typedef Key2Class<Marker> String2Marker;
typedef Key2Class<Chromosome> String2Chromosome;
typedef Key2Class<PN> String2PN;

class Control {
public:
  Control();
  ~Control();
  void probs();
  void readprobfiles();
  void initscore();
  void getmarkerallelefreq(const string &markerid, FloatVec &freq);
  Uint getmarkerindex(const string &markerid);

  Map map;
protected:
  Family *first;
  Family *firstorig;
  Uint numfam;
  int maxbits;
  IV maxnumiv;
  void initializechromosome(const string &id);
  void analyzechromosome();
  void initdist();
  void findnums();
  void inputld();
  void inputdecode();
  String2Chromosome string2chromosome;
  String2PN string2pn;
  String2Double string2traitvalue;
  String2Marker string2marker;
  void getdat(Infile& dat, UintVec &usemarkers, Uint &totuse, Uint &totnum,
              Uint popidx = 0);
  void getpre(Infile& pre, const UintVec usemarkers, const Uint totuse,
              const Uint totnum, Uint popidx = 0);
  int markerused(Uint i, const UintVec usemarkers, Uint totuse);
  Float countvecsneeded();

  bool fromleft(Family *f, Probability &prob, Floatmatrix *q, Floatmatrix *lq,
                Floatmatrix *lqhat, FloatVec tmpq);
  void fromright(Probability &prob, Floatmatrix *lq, Floatmatrix *q,
                 Family *fam);
  void setupfamilies();
};

extern Control *control;

#endif // _CONTROL
