#ifndef _CONVOLVE
#define _CONVOLVE
#include "basic.h"
#include "warning.h"
#include <math.h>

class Convolver {
public:
  Convolver(Uint nb, Uint nf);
  ~Convolver();
  
  void convolve(DoubleMat x, DoubleMat p, UintVec m);
  void write(const string &filename) const;
  Double calcpvalue(Double x) const;
  DoubleVec bin;
  DoubleVec binprob;
protected:
  Uint nbins;
  Uint nfam;
  DoubleVec binnew;
  DoubleVec binprobnew;
  Double binmin;
  Double binwidth;
  Uint nbinsused;
  bool dobinning;

  void add(Double x, Double p, Uint &binsused);
  inline int getbinidx(Double x) const {
#ifdef DEBUG
    assertcond(rint((x - binmin)/binwidth) >= 0 &&
               rint((x - binmin)/binwidth) < nbins,
               string("Bin index out of bounds for x = ") + x +
               " and idx = " + rint((x - binmin)/binwidth))   ;
#endif //DEBUG
    return int(rint((x - binmin)/binwidth));}
};

#endif // _CONVOLVE
