#ifndef _DISTRIBUTION
#define _DISTRIBUTION
#include <map>
#include "basic.h"

typedef vector<Family *> Familyvector;

class Infile;
class Outfile;
class Probability;

class Distribution {
public:
  virtual ~Distribution();
  static void reset(const Map &mp);
  static void set(FloatVec pv, Uint pos, const string &p);
  static void nextfam(Probability &prob, Family *fam, DoubleVec p0);
  // Called if the family currently under investigation has no informative
  // markers
  static void curfamuninformative();
  const string &getpt();
  virtual string describe() const = 0;
  virtual const string &getfamid(Uint ifam) const;
  virtual Uint nfam() const {return families.size();}
  
  // probfilestuff
  static void setnames(bool readprobfiles, bool writeprobfiles);
  static void setprobfilename(const string &pts, const string &distid,
                              const string &filename);
  static bool probfilesexist();
  static void printprobfileswritten();
  static void printprobfilesread();
  static void setnullfilename(const string &distid, const string &filename);
  static void writeprobfiles();
  static void writenullfiles();

  /// Returns true if the family will be used by the distribution.
  /// The default is to to return true if the family is more than 0 bits.
  virtual bool usefamily(Family *fam) const;
  /// Returns true if families that have no uninformative markers are to be
  /// used
  virtual bool useuninformative() const {return true;}
  Familyvector families;

  static bool isnullconstant() {return nullconstant;}
  static void setnullconstant(bool nc) {nullconstant = nc;}
  Uint nnulldist() {return isnullconstant() ? 1 : npos;}
  static void cleanup();

protected:
  static bool nullconstant;
  bool skipcurrentfamily;

  Distribution(const string &p);
  virtual void reset(Uint np) = 0;
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0) = 0;
  virtual void set(FloatVec pv, Uint pos) = 0;
  virtual void skipfam() = 0;
  
  typedef vector<Distribution *> Distributionvector;
  static Distributionvector distributions;

  Uint npos;
  Family *curfamily() {return families.back();}
  static Distribution *finddistribution(const string &desc, const string &pt);
  
  string pt;

  // probfilestuff
  Infile probfilein;
  Outfile probfileout;
  Infile nullfilein;
  Outfile nullfileout;
  virtual void writeprob(const Map &mp) = 0;
  virtual void readprob(Infile& f) = 0;
  virtual void writenull() = 0;
  virtual void readnull(Infile& f) = 0;
  
  static Map const *map;
};

#endif // _DISTRIBUTION
