#include "files.h"
#include "family.h"
#include "distribution.h"
#include "entropy.h"
#include "vecutil.h"

Entropy::Entropy(const string &pt) : Distribution(pt) {}

Entropy::~Entropy() {
  while (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
}

void Entropy::set(FloatVec pv, Uint pos) {
  Float sum = 0;
  for (IV v = 0; v < curfamily()->numiv; v++)
    sum += (pv[v] == 0 ? 0.0 : pv[v]*log(pv[v]));
  familydata.back()->info[pos] = 1.0 + sum/curfamily()->numbits/log(2.0);
}

void Entropy::reset(Uint np) {
  while (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
  npos = np;
}

void Entropy::nextfam(Uint pos, DoubleVec /*p0*/) {
  if (pos == 0) familydata.push_back(new Familydata(this));
}

void Entropy::skipfam() {
  if (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
}

Float Entropy::info(Uint pos) const {
  Float info = 0.0;
  Uint nc = 0;
  for (Uint ifa = 0; ifa < familydata.size(); ifa++) {
    nc += families[ifa]->numbits;
    info += families[ifa]->numbits*familydata[ifa]->info[pos];
  }
  return info/Float(nc);
}

Entropy *Entropy::getentropy(const string &pt) {
  Distribution *dist = Distribution::finddistribution("entropy", pt);
  if (dist != 0) return (Entropy *)dist;
  else return new Entropy(pt);
}
