#ifndef _ENTROPY
#define _ENTROPY
#include "basic.h"

class Entropy : public Distribution {
public:
  Entropy(const string &pt);
  virtual ~Entropy();
  virtual string describe() const {return "entropy";}
  static Entropy *getentropy(const string &pt);

  Float faminfo(Uint ifa, Uint pos) const {return familydata[ifa]->info[pos];}
  Float info(Uint pos) const;

protected:
  class Familydata {
  protected:
    Entropy *owner;
  public:
    Familydata(Entropy *own) : owner(own) {
      NEWVEC(Double, info, owner->npos);
    }
    Familydata(const Familydata &fd) : owner(fd.owner) {
      NEWVEC(Double, info, owner->npos);
    }
    ~Familydata() {DELETEVEC(info);}
    DoubleVec info;
  };
  friend class Entropy::Familydata;
  typedef vector<Familydata *> Familydatavector;
  Familydatavector familydata;

  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0);
  virtual void set(FloatVec pv, Uint pos);
  virtual void skipfam();

  virtual void writeprob(const Map &/*map*/) {}
  virtual void readprob(Infile& /*f*/) {}
  virtual void writenull() {}
  virtual void readnull(Infile& /*f*/) {}
};

#endif // _ENTROPY
