#ifndef _FAMILY
#define _FAMILY
#include "basic.h"

#define NOTRAITVALUE -9.99999e+300

class Person;
class Foundercouple;

class Plist {
public:
  Plist(Person *q, Plist *ch) : p(q), next(ch) {};
  ~Plist() { delete next; };
  Uint length() {return 1 + (next == 0 ? 0 : next->length());}
  Person *p;
  Plist *next;
};

class Node;

class Person {
  friend class Family;
public:
  Person(const string& id,    // Create person with no parents
         Sex sx, Diseasestatus ds, Uint liab, Double trval = NOTRAITVALUE);
  Person(const Person &per);
  ~Person();
  Person *next;          // pointer to next person in family
  string id;
  bool founder() 
    {return mother == 0/* && father == 0*/;}
  bool genotyped;   // has person been genotyped at any marker?
  void getspouses(Person *&s1, Person *&s2) const; // Finds first two spouses
  Sex sex;
  Diseasestatus dstat; // Can be changed to UNKNOWN if uninformative
  Diseasestatus origdstat; // The dstat reported in prefile/affectionfile
  Double traitvalue;
  bool hastraitvalue() {return traitvalue != NOTRAITVALUE;}
  Uint nmrk;        // Number used by haplotyping alg
  Uint liability;
  IntVec gen[2];        // one pair pr. marker (0,0) = unknown
  Person *father;        // 0 = no father
  Person *mother;        // 0 = no mother
  Node *nod[2];          // nodes in graphs (in findq)
  BoolVec genotyp;         // genotyp[m] true if genotyped at marker m
  IV mask;     // mask for inher. vec. bits of all meioses in person
  IV patmask;  // mask for paternal inheritance vector bit
  IV matmask;  // mask for maternal inheritance vector bit
  IV lastbit;  // last bit in mask ((mask + lastbit)/2 = first bit)
  bool removepatbit;
  bool removematbit;
  Plist *children;    // list of children
  void setgenotypes(IntVec g0, IntVec g1, Uint nm);
  void allocgenotypes(Uint nm);
  Foundercouple *fc; // Pointer is set for founder couples, and their children

protected:
  Uint nmkr;        // number of markers that this person has genotype info on
  void addparents(Person *fath, Person *moth); // Add parents
  Uint visit(); // used by connected
  Uint visitup();
  Uint visitdown();
  Uint visitchildren();
  Uint visitparents();
  bool ishodgeinformativeup(Uint ngen);
  bool ishodgeinformativedown(Uint ngen);

  void init(const string& id, Sex sx);
  void sort(bool down, Person **last);
  void addchild(Person *c);
  void removechild(Person *p);
  void removechildren();
  bool visitedup;     // true after visitup called
  bool visiteddown;   // true after visitdown called
  bool processed;     // used by sort
};

class Foundercouple {
public:
  Person *husband;
  Person *wife;
  IV mask;
  IV childrenmask;
  Foundercouple *next;
  IV lastgcbit;
  IV bitbeforefirstgcbit;
  inline IV lastcbit() const
    {return husband->lastbit;}
  inline IV pi(IV v) {
    Uint shift = wt[wife->mask];
    return v & ~childrenmask | ((wife->mask & v) >> shift) |
      ((husband->mask & v) << shift);
  }
  void swapdstat();
  bool asymmetric() const;
  
  Foundercouple(Person *h, Person *w, Foundercouple *n);
};

class Kinship;

class Family {
public:
  Family(const string &id, Uint popidx = 0); // Create empty family, no members
  Family(const Family &fam);
  ~Family();
  void organize(const vector<string> &faid, const vector<string> &moid);
  void organize();
  void setup();
  string id;
  Family *next;         // next family
  Person *first;        // first person in family
  Foundercouple *firstfoundercouple;
  Person *firstdescendant;
  Uint num;           // number of members
  Uint numnf;         // number of descendants, m
  Uint numf;          // number of founders, f (num = m + f)
  Uint numiv;         // number of inheritance vectors
  Uint numbits;       // log2(numiv)
  Uint nqtl;          // number of people with observed trait values
  Uint populationindex; // index of population that this family 
                        // belongs to
  Uint numfc;
  IV mask;
  IV lastfounderbit;  // the last bit corresponding to a meisois in a founder
  Person *addperson(const string& pid, Sex sex, Diseasestatus ds,
                    Uint liab, Double trval = NOTRAITVALUE);
  Person *addperson(Person *p, bool addpar = true);
  void removeperson(Person *p);
  void removeuninformativeperson(Person *p);
  Uint nasymmetricfoundercouples() const;
  void countbits();
  Kinship *kinship;
  void calckinship();
  Uint hodgeninfm(); // counts number of informative affecteds for Sue Hodge's
                     // weighting scheme
  void pseudonull(DoubleVec p0); // Calculates the prior IV distribution at the
                                 // start of the pseudoautosomal chromsome region
  Uint countinformative() const;
protected:
  bool hasinformativerelatives(Person *p);
  Uint countinformativerelatives(Person *q);
  Person *findperson(const string& id); // Return pointer to person
  // with given id
  void init();
  void putfoundersfirst();
  bool phenotypesconnected();
  bool connected();      // return true if family connected
  void sort();           // sorts so that children come after parents
                         // Also finds num, mumf, numnf, numiv.
  void trim(); // Removes uninformative people from family
  void findfoundercouples();
  string genpar(int nr);
  void splitunconnectedphenotypes();
  void removeuninformativephenotypes();
  void split();
  void findorinsert(Person *p);

  Person *last;         // pointer to last person added to pedigree
                        // not maintained after last call to addperson
  Person *lastfounder;  // pointer to last founder
  Uint ngenpar;
};

#endif // _FAMILY
