#include "files.h"
#include "warning.h"
#include <sys/stat.h>
#include <errno.h>

string File::subdir = "";

File::File(bool bin) :
    fstream(), name(""), mode(in | out | (bin ? binary : openmode(0))),
    binfile(bin) {
//  setstate(ios::failbit);
}

File::File(const string& fname, bool bin) :
    fstream(), name(fname),
    mode(in | out | trunc | (bin ? binary : openmode(0))), binfile(bin) {}

bool File::exists() {
  if (is_open()) return 1;
  else {
    struct stat statbuf;
    return stat(name.c_str(), &statbuf) == 0;
  }
}

bool File::isempty() {
  bool wasopen = is_open();
  int pos;
  if (!wasopen) open(in);
  if (mode == in) { 
    seekg(0, end);
    pos = tellg();
  }
  else {
    seekp(0, end);
    pos = tellp();
  }
  if (!wasopen) close();
  return pos == 0;
}

bool File::fileok(openmode mod) {
  if (is_open()) return mode & mod != 0;
  else if (!(mod & out)) return exists();// && !isempty();
  else {
    struct stat statbuf;
    if (name.substr(name.length() - 1, 1) == "/") return false;
    else if (exists()) {
      return stat(name.c_str(), &statbuf) == 0 && (statbuf.st_mode & S_IFREG);
    }
    else {
      Uint lastslash = name.rfind('/');
      if (lastslash == string::npos || lastslash == 0) return true;
      else {
        // Note that lastslash > 0
        string pathname = name.substr(0, lastslash);
        return stat(pathname.c_str(), &statbuf) == 0 &&
          (statbuf.st_mode & S_IFDIR);
      }
    }
  }
}

void File::setname(const string& fname) {
  name = fname;
}

void File::setname(const string& fname, const string& deflt) {
  if (fname == "") setname(deflt);
  else setname(fname);
}

void File::open(openmode mod) {
  mode = mod | (binfile ? binary : openmode(0));
  string tmpname = (subdir != "" ? subdir + "/" : "") + name;
  fstream::open(tmpname.c_str(), mode);
  clear();
}

void File::open(const string& fname) {
  setname(fname);
  open(in | out | trunc);
}

void File::close() {
  fstream::close();
  setstate(ios::failbit);
}

void File::setsubdir(const string &sd) {
  subdir = sd;
  if (mkdir(subdir.c_str(), 493) != 0)
    assertcond(errno == EEXIST, "Unable to create directory " + subdir);
}
