#ifndef _FILES
#define _FILES
#include <fstream>
#include "basic.h"
#include "warning.h"

class File : public fstream {
// The difference between File and fstream is that File("xxx") starts off
// being closed, whereas fstream("xxx") starts off being open.
// Also, File() starts off being in fail state, but fstream() is in good state.
// default is that the file is in | out, the derived classes Infile and Outfile
// handle in and out
public:
  File(bool bin = false);
  File(const string& fname, bool bin = false);
  ~File() {if (is_open()) close();};
  string name;
  openmode mode;
  virtual bool fileok() { return fileok(in | out); }
  void setname(const string& fname);
  void setname(const string& fname, const string& deflt);
  virtual void open() { open(in | out | trunc); }
  void open(const string& fname);
  void close();
//  virtual bool is_open() const {return fstream::is_open();}
//  virtual bool is_open() const {return !fstream::operator!();}
  operator void*()
    { return name == "" || !is_open() || fail() ? (void*)0 : (void*)(-1); }
  bool operator!()
    { return name == "" || !is_open() || fail(); }
  bool exists();
  bool isempty();
  bool assigned() const {return name != "";}
  void reopen()
    {
      open((mode & ~ios::trunc) | ios::app);}
  static void setsubdir(const string &sd);
  void optcheck(const string& ftype) {
    optassert(name != "", "No " + ftype + " given");
    optassert(fileok(), "Cannot open " + ftype + " " + name);
  }
protected:
  bool binfile;
  static string subdir; // If set then file will be written in "subdir/name"
  void open(openmode mod);
  bool fileok(openmode mod);
};

class Infile : public File {
public:
  Infile() : File() {}
  Infile(const string& fname) : File(fname) {}
  virtual bool fileok() { return File::fileok(in); }
  virtual void open() { File::open(in); }
};

class Outfile : public File {
public:
  Outfile() : File() {}
  Outfile(const string& fname) : File(fname) {}
  virtual bool fileok() { return File::fileok(out | trunc); }
  virtual void open() { File::open(out | trunc); }
};


#endif // _FILES
