#include "basic.h"
#include "findassoc.h"
#include "family.h"
#include "options.h"

/////////////////////////////////////////////////////////////////////////
// Calcassocnode

FloatVec Calcassocnode::pA2 = 0;
FloatVec Calcassocnode::pA3 = 0;

/////////////////////////////////////////////////////////////////////////
// Calcassocperson

FloatVec Calcassocperson::ETM2 = 0;
FloatVec Calcassocperson::ETM3 = 0;

Calcassocperson::Calcassocperson(Person *p, Calcassocperson *first) :
    inherited(p, first), weight(0) {}
    
Calcassocperson::~Calcassocperson() {}

void Calcassocperson::calcmoments(IV v, FloatVec p, FloatVec ET2,
                                  FloatVec ET3, Uint nalleles, Uint gam) {
  int Kf = per->patmask ? 1 : 0;
  int Km = per->matmask ? 1 : 0;
  
  for (int K1 = 0; K1 <= Km; K1++) {
    if (K1) v += per->matmask;
    if (mother != 0) nod[1] = mother->nod[K1];
    if (weight != 0.0 && per->genotyp[gam]) {
      nod[1]->addweight(weight, ETM2, ETM3, nalleles);
    }
    for (int K0 = 0; K0 <= Kf; K0++) {
      if (K0) v += per->patmask;
      if (father != 0 && (!options->sexlinked || per->sex == FEMALE))
        nod[0] = father->nod[K0];
      else if (father != 0) nod[0] = nod[1];

      if (weight != 0.0 && per->genotyp[gam]) {
        nod[0]->addweight(weight, ETM2, ETM3, nalleles);
      }
      if (next == 0) {
        for (Uint a = 0; a < nalleles; a++) {
          Double prob = (p == 0 ? 1.0 : p[v]);
          ET2[a] += ETM2[a]*prob;
          ET3[a] += ETM3[a]*prob;
        }
      }
      else
        ((Calcassocperson *)next)->calcmoments(v, p, ET2, ET3,
                                               nalleles, gam);
      if (weight != 0.0 && per->genotyp[gam])
        nod[0]->dropweight(weight, ETM2, ETM3, nalleles);
    }
    v &= ~per->patmask;
    if (weight != 0 && per->genotyp[gam])
      nod[1]->dropweight(weight, ETM2, ETM3, nalleles);
  }
}

void Calcassocperson::resetETM(Uint nalleles) {
  DELETEVEC(ETM2);
  DELETEVEC(ETM3);
  NEWVEC(Float, ETM2, nalleles);
  NEWVEC(Float, ETM3, nalleles);
  zero(ETM2, nalleles);
  zero(ETM3, nalleles);
}
