#ifndef _FINDASSOC
#define _FINDASSOC
#include "basic.h"
#include "pairwise.h"
#include "vecutil.h"

class Calcassocnode {
protected:
  static FloatVec pA2;
  static FloatVec pA3;
  
  Float weight;
  Float weight2;
  Float weight3;

public:
  Calcassocnode() : weight(0), weight2(0), weight3(0) {}

  static void setfreq(FloatVec freq, Uint nalleles) {
    DELETEVEC(pA2);
    DELETEVEC(pA3);
    NEWVEC(Float, pA2, nalleles);
    NEWVEC(Float, pA3, nalleles);
    for (Uint a = 0; a < nalleles; a++) {
      pA2[a] = freq[a]*(1.0 - freq[a]);
      pA3[a] = freq[a]*(1.0 - freq[a]*(3.0 - 2*freq[a]));
    }
  }

  void updateETM(FloatVec ETM2, FloatVec ETM3, Uint nalleles, Float sign) {
    for (Uint a = 0; a < nalleles; a++) {
      ETM2[a] += sign*weight2*pA2[a];
      ETM3[a] += sign*weight3*pA3[a];
    }
  }
  
  void addweight(Float w, FloatVec ETM2, FloatVec ETM3, Uint nalleles) {
    updateETM(ETM2, ETM3, nalleles, -1);
    weight += w;
    weight2 = weight*weight;
    weight3 = weight*weight2;
    updateETM(ETM2, ETM3, nalleles, 1);
  }
  
  void dropweight(Float w, FloatVec ETM2, FloatVec ETM3, Uint nalleles) {
    updateETM(ETM2, ETM3, nalleles, -1);
    weight -= w;
    weight2 = weight*weight;
    weight3 = weight*weight2;
    updateETM(ETM2, ETM3, nalleles, 1);
 }

  void backup(FloatVec source, FloatVec source2, FloatVec source3,
              FloatVec target, FloatVec target2, FloatVec target3,
              Uint nalleles) {
    copyvec(target, source, nalleles);
    copyvec(target2, source2, nalleles);
    copyvec(target3, source3, nalleles);
  }

  void restore(FloatVec source, FloatVec source2, FloatVec source3,
               FloatVec target, FloatVec target2, FloatVec target3,
               Uint nalleles) {
    copyvec(source, target, nalleles);
    copyvec(source2, target2, nalleles);
    copyvec(source3, target3, nalleles);
  }
};

class Calcassocperson : public Pairwiseperson<Calcassocnode> {
  typedef Pairwiseperson<Calcassocnode> inherited;
protected:
  static FloatVec ETM2;
  static FloatVec ETM3;
public:
  Float weight;

  Calcassocperson(Person *p, Calcassocperson *first);
  ~Calcassocperson();

  void calcmoments(IV v, FloatVec p, FloatVec ET2, FloatVec ET3,
                   Uint nalleles, Uint gam);
  static void resetETM(Uint nalleles);
};

#endif // _FINDASSOC
