#ifndef _FINDNORMAL
#define _FINDNORMAL
#include "basic.h"
#include "family.h"

class FindNormalLoglik {
protected:
  // Temporary data storage used in calculations
  DoubleMat E;
  UintMat ibd;
  DoubleMat L;
  DoubleVec y;
  Uint curnqtl;
  DoubleVec traitvalues;

  void calcloglik(Family *family, DoubleVec S, Plist *pl, IV v, Uint pi,
                  Double log_det, Double xEx, Double sigma2, Double shared,
                  Double sigma2_g, Double sigma2_d);
  void extracttraitvalues(Family *family);
  void initialize(Family *fam);
  void cleanup();
  bool hasphenotypeddesc(Person *p) const;
public:
  FindNormalLoglik() : E(0), ibd(0), L(0), y(0), curnqtl(0), traitvalues(0) {}
  ~FindNormalLoglik();
  void calc(Family *fam, DoubleVec S, Double sigma2, Double shared,
            Double sigma2_g, Double sigma2_d);
  Double calc(Family *fam, DoubleVec ibd1, DoubleVec ibd2, Double sigma2,
              Double shared, Double sigma2_g, Double sigma2_d);
};

#endif // _FINDNORMAL
