#include "findscore.h"
#include "calcscore.h"
#include "files.h"
#include "options.h"

void Scoreperson::resetdstat() {
  if (per->founder()) {
    Double initcount = per->dstat == AFFECTED ? 1.0 : 0.0;
    nod[0]->setinitcount(initcount);
    nod[1]->setinitcount(initcount);
    if (next != 0)
      ((Scoreperson *)next)->resetdstat();
  }
}

Scoreperson::Scoreperson(Person *p, Scoreperson *first) :
    Pairwiseperson<Founderallele>(p, first) {
  if (isfounder()) {
    Double initcount = per->dstat == AFFECTED ? 1.0 : 0.0;
    nod[0]->setinitcount(initcount);
    if (!options->sexlinked || per->sex == FEMALE)
      nod[1]->setinitcount(initcount);
  }
}

void Scoreperson::calcsall(IV v, Double B, DoubleVec S) {
  int Kf = per->patmask ? 1 : 0;
  int Km = per->matmask ? 1 : 0;
  
  for (int K1 = 0; K1 <= Km; K1++) {
    if (K1) v += per->matmask;
    if (mother != 0) nod[1] = mother->nod[K1];
    for (int K0 = 0; K0 <= Kf; K0++) {
      if (K0) v += per->patmask;
      if (father != 0 && (!options->sexlinked || per->sex == FEMALE))
        nod[0] = father->nod[K0];
      else if (father != 0) nod[0] = nod[1];
      if (per->dstat == AFFECTED) {
        if (next == 0) {
          S[v] += B*(nod[0]->count + 1.0);
          if (!options->sexlinked || per->sex == FEMALE)
            S[v] += B*(nod[1]->count + 1.0);
        }
        else {
          Double Bnew = B;
          nod[0]->addsall(Bnew);
          ((Scoreperson *)next)->calcsall(v, Bnew, S);
          nod[0]->remove();
          if (!options->sexlinked || per->sex == FEMALE) {
            Bnew = B;
            nod[1]->addsall(Bnew);
            ((Scoreperson *)next)->calcsall(v, Bnew, S);
            nod[1]->remove();
          }
        }
      }
      else {
        if (next == 0) S[v] += B;
        else ((Scoreperson *)next)->calcsall(v, B, S);
      }
    }
    v &= ~per->patmask;
  }
}

void Scoreperson::calcsrobdom(IV v, Double B, DoubleVec S) {
  int Kf = per->patmask ? 1 : 0;
  int Km = per->matmask ? 1 : 0;
  
  for (int K1 = 0; K1 <= Km; K1++) {
    if (K1) v += per->matmask;
    if (mother != 0) nod[1] = mother->nod[K1];
    for (int K0 = 0; K0 <= Kf; K0++) {
      if (K0) v += per->patmask;
      if (father != 0 && (!options->sexlinked || per->sex == FEMALE))
        nod[0] = father->nod[K0];
      else if (father != 0) nod[0] = nod[1];
      Double Bnew = B;
      if (per->dstat == AFFECTED) {
        nod[0]->addsrobdom(Bnew);
        if (nod[0] != nod[1]) nod[1]->addsrobdom(Bnew);
      }
      if (next == 0) S[v] += Bnew;
      else ((Scoreperson *)next)->calcsrobdom(v, Bnew, S);
      if (per->dstat == AFFECTED) {
        nod[0]->removesrobdom();
        if (nod[0] != nod[1]) nod[1]->removesrobdom();
      }
    }
    v &= ~per->patmask;
  }
}

void Scoreperson::calcsmnallele(IV v, Double B, DoubleVec S) {
  int Kf = per->patmask ? 1 : 0;
  int Km = per->matmask ? 1 : 0;
  
  for (int K1 = 0; K1 <= Km; K1++) {
    if (K1) v += per->matmask;
    if (mother != 0) nod[1] = mother->nod[K1];
    for (int K0 = 0; K0 <= Kf; K0++) {
      if (K0) v += per->patmask;
      if (father != 0 && (!options->sexlinked || per->sex == FEMALE))
        nod[0] = father->nod[K0];
      else if (father != 0) nod[0] = nod[1];
      Double Bnew = B;
      if (per->dstat == AFFECTED) {
        nod[0]->addsmnallele(Bnew);
        if (!options->sexlinked || per->sex == FEMALE)
          nod[1]->addsmnallele(Bnew);
      }
      if (next == 0) S[v] += Bnew;
      else ((Scoreperson *)next)->calcsmnallele(v, Bnew, S);
      if (per->dstat == AFFECTED) {
        nod[0]->remove();
        if (!options->sexlinked || per->sex == FEMALE)
          nod[1]->remove();
      }
    }
    v &= ~per->patmask;
  }
}

void Scoreperson::calcspairs(IV v, Double B, DoubleVec S, bool homoz) {
  int Kf = per->patmask ? 1 : 0;
  int Km = per->matmask ? 1 : 0;
  
  for (int K1 = 0; K1 <= Km; K1++) {
    if (K1) v += per->matmask;
    nod[1] = mother->nod[K1];
    for (int K0 = 0; K0 <= Kf; K0++) {
      if (K0) v += per->patmask;
      if (!options->sexlinked || per->sex == FEMALE) nod[0] = father->nod[K0];
      else nod[0] = nod[1];
      if (per->dstat == AFFECTED) {
        Double Bnew = B + nod[0]->count;
        Bnew += (!homoz && (!options->sexlinked || per->sex == FEMALE) ||
                 homoz && options->sexlinked && per->sex == MALE ?
                 nod[1]->count : 0);
        nod[0]->addspairs();
        if (!options->sexlinked || per->sex == FEMALE) {
          Bnew += homoz ? nod[1]->count : 0;
          nod[1]->addspairs();
        }
        if (next == 0) S[v] += Bnew;
        else ((Scoreperson *)next)->calcspairs(v, Bnew, S, homoz);
        if (!options->sexlinked || per->sex == FEMALE) nod[1]->remove();
        nod[0]->remove();
      }
      else {
        if (next == 0) S[v] += B;
        else ((Scoreperson *)next)->calcspairs(v, B, S, homoz);
      }
    }
    v &= ~per->patmask;
  }
}

// Not implemented for X-linked
void Scoreperson::calcspairs_ps(IV v, Double B, DoubleVec S,
                                Double w_mm, Double w_mf, Double w_ff) {
  int Kf = per->patmask ? 1 : 0;
  int Km = per->matmask ? 1 : 0;
  
  for (int K1 = 0; K1 <= Km; K1++) {
    if (K1) v += per->matmask;
    nod[1] = mother->nod[K1];
    for (int K0 = 0; K0 <= Kf; K0++) {
      if (K0) v += per->patmask;
      nod[0] = father->nod[K0];
      if (per->dstat == AFFECTED) {
        Double Bnew = B;
        Bnew += (w_ff*nod[0]->count_pat + w_mf*nod[0]->count_mat +
                 w_mf*nod[1]->count_pat + w_mm*nod[1]->count_mat);
        nod[0]->addps_pat();
        nod[1]->addps_mat();
        if (next == 0) S[v] += Bnew;
        else ((Scoreperson *)next)->calcspairs_ps(v, Bnew, S, w_mm, w_mf, w_ff);
        nod[0]->removeps_pat();
        nod[1]->removeps_mat();
      }
      else {
        if (next == 0) S[v] += B;
        else ((Scoreperson *)next)->calcspairs_ps(v, B, S, w_mm, w_mf, w_ff);
      }
    }
    v &= ~per->patmask;
  }
//   int Kf = per->patmask ? 1 : 0;
//   int Km = per->matmask ? 1 : 0;
  
//   for (int K1 = 0; K1 <= Km; K1++) {
//     if (K1) v += per->matmask;
//     nod[1] = mother->nod[K1];
//     for (int K0 = 0; K0 <= Kf; K0++) {
//       if (K0) v += per->patmask;
//       nod[0] = father->nod[K0];
//       if (per->dstat == AFFECTED) {
//         Double Bnew = B;
//         if (per->fc == 0) {
//           Bnew += (w_ff*nod[0]->count_pat + w_mf*nod[0]->count_mat +
//                    w_mf*nod[1]->count_pat + w_mm*nod[1]->count_mat);
//           nod[0]->addps_pat(2);
//           nod[1]->addps_mat(2);
//         }
//         else {
//           Bnew += ((w_ff*nod[0]->count_pat + w_mf*nod[0]->count_mat +
//                     w_mf*nod[1]->count_pat + w_mm*nod[1]->count_mat) +
//                    (w_mm*nod[0]->count_mat + w_mf*nod[0]->count_pat +
//                     w_mf*nod[1]->count_mat + w_ff*nod[1]->count_pat));
//           nod[0]->addps_pat(1);
//           nod[0]->addps_mat(1);
//           nod[1]->addps_pat(1);
//           nod[1]->addps_mat(1);
//         }
//         if (next == 0) S[v] += Bnew;
//         else ((Scoreperson *)next)->calcspairs_ps(v, Bnew, S, w_mm, w_mf, w_ff);
//         if (per->fc == 0) {
//           nod[0]->removeps_pat(2);
//           nod[1]->removeps_mat(2);
//         }
//         else {
//           nod[0]->removeps_pat(1);
//           nod[0]->removeps_mat(1);
//           nod[1]->removeps_pat(1);
//           nod[1]->removeps_mat(1);
//         }
//       }
//       else {
//         if (next == 0) S[v] += B;
//         else ((Scoreperson *)next)->calcspairs_ps(v, B, S, w_mm, w_mf, w_ff);
//       }
//     }
//     v &= ~per->patmask;
//   }
}
