#ifndef _FINDSCORE
#define _FINDSCORE
#include "basic.h"
#include "family.h"
#include "pairwise.h"

#define ROBDOMR 7.0

class Founderallele {
public:
  Founderallele() : count(0), count_mat(0), count_pat(0) {}
  void setinitcount(Double c) {count = c;}

  Double count;
  Double count_mat;
  Double count_pat;
  
  inline void addsall(Double &B) {count += 1.0; if (count > 1.0) B *= count;}
  inline void addsrobdom(Double &B) {
    if (count == 0.0) {
      B -= 1.0;
      count = ROBDOMR;
    }
    else {
      B -= count;
      count *= ROBDOMR;
    }
    B += count;
  }
  inline void addsmnallele(Double &B)
    {if (count == 0.0) B += -1.0; count += 1.0;}
  inline void addspairs() {count += 1.0;}
  inline void removesrobdom()
    {if (count == ROBDOMR) count = 0.0; else count /= ROBDOMR;}
  inline void remove() {count -= 1.0;}

  inline void addps_mat(Double x = 1.0) {count_mat += x;}
  inline void addps_pat(Double x = 1.0) {count_pat += x;}
  inline void removeps_mat(Double x = 1.0) {count_mat -= x;}
  inline void removeps_pat(Double x = 1.0) {count_pat -= x;}
};

class Scoreperson : public Pairwiseperson<Founderallele> {
public:
  Scoreperson(Person *p, Scoreperson *first);
  virtual ~Scoreperson() {}
  bool isfounder() const {return per->founder();}
  void calcsall(IV v, Double B, DoubleVec S);
  void calcspairs(IV v, Double B, DoubleVec S, bool homoz);
  void calcsrobdom(IV v, Double B, DoubleVec S);
  void calcsmnallele(IV v, Double B, DoubleVec S);
  void calcspairs_ps(IV v, Double B, DoubleVec S, Double w_mm,
                     Double w_mf, Double w_ff);
  virtual void calcgenspairs(IV /*v*/, Double /*B*/, DoubleVec /*S*/) {}
  void resetdstat();
};

#endif // _FINDSCORE
