#include "fishersexact.h"

Doublevector Fishersexact::log_g;

void Fishersexact::setuplgamma(Uint n) {
  if (n + 1> log_g.size()) {
    Uint old_n = (log_g.size() == 0 ? 0 : log_g.size() - 1);
    log_g.resize(n + 1, 0.0);
    for (Uint i = old_n + 1; i < n + 1; i++)
      log_g[i] = log_g[i - 1] + log(double(i));
  }
}

Double erfinv(Double y_u) {
  Double y = 2.0*y_u - 1.0;
  
  Double a[4] = { 0.886226899, -1.645349621,  0.914624893, -0.140543331};
  Double b[4] = {-2.118377725,  1.442710462, -0.329097515,  0.012229801};
  Double c[4] = {-1.970840454, -1.624906493,  3.429567803,  1.641345311};
  Double d[2] = { 3.543889200,  1.637067800};
  Double pi = 4*atan(1.0);
  Double y0 = 0.7;
  Double x;
  if (fabs(y) <= y0) {
    Double z = y*y;
    x = y * (((a[3]*z+a[2])*z+a[1])*z+a[0]) / 
      ((((b[3]*z+b[2])*z+b[1])*z+b[0])*z+1);
  }
  else if (y > 0 && y < 1.0) {
    Double z = sqrt(-log((1-y)/2.0));
    x = (((c[3]*z+c[2])*z+c[1])*z+c[0]) / ((d[1]*z+d[0])*z+1);
  }
  else if (y < 0 && y > -1.0) {
    Double z = sqrt(-log((1+y)/2.0));
    x = -(((c[3]*z+c[2])*z+c[1])*z+c[0]) / ((d[1]*z+d[0])*z+1);
  }
  else {
    return sqrt(-1.0);
  }
  x = x - (erf(x) - y) / (2/sqrt(pi) * exp(-x*x));
  x = x - (erf(x) - y) / (2/sqrt(pi) * exp(-x*x));
  return -sqrt(2.0)*x;
}

Double Fishersexact::test(Uint a, Uint b, Uint c, Uint d) {
  if (a == 0) return log(.0);
  
  Uint n = a + b + c + d;
  setuplgamma(n);
  
  const Double F = (get(a + b) + get(c + d) + get(a + c) + get(b + d) -
                    get(n));
  Double P = 0;

  Uint STEPS = min(c, b);
  
  for (int i = STEPS; i >= 0; i--)
    P += exp(F - get(a + i) - get(d + i) -
             get(int(b) - i) - get(int(c) - i));
  
  return erfinv(P);
}
