#ifndef _FISHERSEXACT
#define _FISHERSEXACT
#include "basic.h"

class Fishersexact {
public:
  // Returns the z-score of a one sided Fisher's exact test
  static Double test(Uint a, Uint b, Uint c, Uint d);
  
protected:
  static Doublevector log_g;

  static void setuplgamma(Uint n);
  
  static Double get(Uint i) {
    assertinternal(i < log_g.size());
    return log_g[i];
  }
};

#endif // _FISHERSEXACT
