#ifndef _FORMATOUTPUT
#define _FORMATOUTPUT
#include "basic.h"

#include <iostream>

const string Floattostring(Float x, Uint prec);

inline void lowercase (string& s) {
  for (Uint i = 0; i < s.length(); i++) s[i] = tolower(s[i]);
}

const Double FIVEP10[10] = {0.5,
                            0.05,
                            0.005,
                            0.0005,
                            0.00005,
                            0.000005,
                            0.0000005,
                            0.00000005,
                            0.000000005,
                            0.0000000005};

#define NO_THRESH 9.913e300
inline void fmtout(ostream& f, Uint n, Uint m, Double x, Uint minspace = 1,
                   Double thresh = NO_THRESH) {
  assertinternal(n > 0);
  Uint width = n - minspace;
  if (minspace > 0) {
    f << " ";
  }  
  if (thresh == NO_THRESH || fabs(x) > thresh || x == 0) {
    f.setf(ios::fixed | ios::showpoint, ios::floatfield);
    f.width(width);
    f.precision(m);
    if (x < 0 && (m <= 9 && x >= -FIVEP10[m] || x >= -FIVEP10[9])) x = 0.0;
    f << x;
  }
  else {
    f.setf(ios::scientific | ios::showpoint, ios::floatfield);
    f.width(width);
    f.precision(m - 4);
    f << x;
  }    
}

inline void fmtout(ostream& f, Uint n, const string& x, bool left = true) {
  if (!left) for (Uint i = x.length(); i < n; i++) f << " ";
  f << x;
  if (left) for (Uint i = x.length(); i < n; i++) f << " ";
}

inline void fmtout(ostream& f, Uint n, int x) {
  f.width(n);
  f << x;
}

inline string space2dot(const string &a) {
  string res = a;
  for (string::iterator i = res.begin(); i != res.end(); i++)
    if (*i == ' ') *i = '.';
  return res;
}

#endif // _FORMATOUTPUT
