#include "family.h"
#include "files.h"
#include "forceddist.h"
#include "map.h"
#include "options.h"
#include "singlelocus.h"
#include "utils.h"
#include "vecutil.h"
#include "fmtout.h"

Forceddist::Forceddist(const string &forced, const string &famforced) :
    Viterbidist("fpt"), overallforced(0) {
  forcedfile.setname(forced, "forced.out");
  famforcedfile.setname(famforced, "f" + forcedfile.name);
}

void Forceddist::reset(Uint np) {
  if (forcedfile.is_open()) {
    forcedfile.close();
    famforcedfile.close();
  }
  forcedfile.open();
  famforcedfile.open();
  DELETEVEC(overallforced);
  NEWVEC(Uint, overallforced, map->num);
  zero(overallforced, map->num);
  Viterbidist::reset(np);
}

Forceddist *Forceddist::getforceddist(const string &forced,
                                      const string &famforced) {
  for (Uint d = 0; d < distributions.size(); d++)
    optassert(distributions[d]->getpt() != "fpt",
              "More than one FORCEDXOVERS lines.");
  return new Forceddist(forced, famforced);
}

Forceddist::~Forceddist() {
  DELETEVEC(overallforced);
}

void Forceddist::forcedrecombout() {
  Uint total = 0;
  for (Uint gam = 0; gam < map->num - 1; gam++) {
    Uint forced = countrecombs(curfamily(), path[gam], path[gam + 1]);
    overallforced[gam] += forced;
    total += forced;
    famforcedfile << curfamily()->id << "\t";
    famforcedfile.setf(ios::right, ios::adjustfield);
    fmtout(famforcedfile, 7, 3, map->markerpos[0][gam], 0);
    fmtout(famforcedfile, 9, forced);
    famforcedfile << "  " << map->markername[gam] << "\n";
  }
  famforcedfile << curfamily()->id << "\t" << "Total:\t" << total << "\t"
                      << map->markername[map->num - 1] << "\n";
}

void Forceddist::overallforcedrecombout() {
  Uint total = 0;
  for (Uint gam = 0; gam < map->num - 1; gam++) {
    total += overallforced[gam];
    fmtout(forcedfile, 7, 3, map->markerpos[0][gam], 0);
    fmtout(forcedfile, 9, overallforced[gam]);
    forcedfile << "  " << map->markername[gam] << "\n";
  }
  forcedfile << "Total:\t" << total << "\t"
             << map->markername[map->num - 1] << "\n";
}

void Forceddist::print() const {
  message("FORCEDXOVERS " + forcedfile.name + " " + famforcedfile.name);
}

void Forceddist::set(FloatVec pv, Uint pos) {
  Viterbidist::set(pv, pos);
  if (pos == 0) forcedrecombout();
}

void Forceddist::gettheta(Uint, Float &tht, Float &tht_female) const {
  tht = .1;
  if (options->sexspecific)
    tht_female = .1;
  else
    tht_female = -1;
}
