#ifndef _FORCEDDIST
#define _FORCEDDIST
#include "basic.h"
#include "viterbidist.h"

class Forceddist : public Viterbidist {
public:
  virtual ~Forceddist();
  static Forceddist *getforceddist(const string &forced,
                                   const string &famforced);

  void forcedrecombout();
  void overallforcedrecombout();
  virtual string describe() const {return "forcedxovers";}
  virtual void print() const;

  virtual bool useuninformative() const {return false;}
private:
  Outfile forcedfile;
  Outfile famforcedfile;
  Forceddist(const string &forced, const string &famforced);
  
  UintVec overallforced;

protected:
  virtual void reset(Uint np);
  virtual void set(FloatVec pv, Uint pos);

  virtual void gettheta(Uint gam, Float &tht, Float &tht_female) const;
};

#endif // _FORCEDDIST
