#ifndef _FOUNDERHAPLOMODEL
#define _FOUNDERHAPLOMODEL
#include "model.h"
#include "founderhaplodist.h"

class Distribution;

class Founderhaplomodel : public Model {
public:
  Founderhaplomodel(const string &of, bool ord) : Model("spt"), ordered(ord) {
    if (ordered)
      distribution = Orderedfounderhaplodist::getorderedfounderhaplodist(of);
    else
      distribution = Founderhaplodist::getfounderhaplodist(of);
  }
  
  virtual ~Founderhaplomodel() {delete distribution;}

  virtual void output() {}
  // prints description
  virtual void print() const {
    if (ordered)
      ((Orderedfounderhaplodist *)distribution)->print();
    else
      ((Founderhaplodist *)distribution)->print();
  }
  
protected:
  bool ordered;
  
  virtual void totline(ostream &/*f*/, Uint /*pos*/) {}
  virtual void famline(ostream &/*f*/, Uint /*ifa*/, Uint /*pos*/) {}
  virtual void totheader(ostream &/*f*/) {}
  virtual void famheader(ostream &/*f*/) {}
};

#endif // _MODEL
