#ifndef _FOUNDERPERSON
#define _FOUNDERPERSON
#include "basic.h"
#include "pairwise.h"

template<class Founderallele, class FP>
class Founderperson : public Pairwiseperson<Founderallele> {
protected:
  bool pattrans;
  bool mattrans;

public:
  Founderperson(Person *p, FP *first, bool pat, bool mat) :
      Pairwiseperson<Founderallele>(p, first), pattrans(pat), mattrans(mat) {}

   static FP *find(Person *p, FP *first) {
    for (FP *fcp = first; fcp != 0;
         fcp = (FP *)(fcp->next))
      if (fcp->per == p) return fcp;
    return 0;
  }

  static FP *add(Person *p, FP *&first,
                                 bool pat, bool mat) {
    FP *fcp = find(p, first);
    if (fcp == 0) {
      fcp = new FP(p, first, pat, mat);
      if (first == 0) first = fcp;
    }
    else {
      fcp->pattrans |= pat;
      fcp->mattrans |= mat;
    }
    return fcp;
  }

  static void addleaves(FP *first) {
    for (FP *fcp = first; fcp != 0;
         fcp = (FP *)(fcp->next)) {
      Person *p = fcp->per;
      for (Plist *c = p->children; c != 0; c = c->next) 
        if (c->p->origdstat == AFFECTED)
          adddescendant(c->p, p->sex, first);
    }
  }

  static void addfounder(Person *p, FP *&first) {
    assertinternal(p != 0);
    assertinternal(p->founder());

    if (find(p, first) != 0) return;
    add(p, first, true, true);

    for (Plist *c = p->children; c != 0; c = c->next) 
      if (hasaffecteddescendants(c->p, true))
        addcross(c->p, first);
  }
  
  static void adddescendant(Person *p, Sex sex, FP *first) {
    add(p, first, sex == MALE, sex == FEMALE);
  }
  
  static void addcross(Person *p, FP *first) {
    if (find(p, first) != 0) return;
    assertinternal(first != 0);
    assertinternal(!p->founder());

    if (p->father->founder()) addfounder(p->father, first);
    else addcross(p->father, first);
    if (p->mother->founder()) addfounder(p->mother, first);
    else addcross(p->mother, first);

    add(p, first, true, true);

    for (Plist *c = p->children; c != 0; c = c->next) 
      if (hasaffecteddescendants(c->p, true))
        addcross(c->p, first);
  }

  static void print(ostream &out, FP *first) {
    for (FP *p = first; p != 0; p = (FP *)p->next)
      if (p->per->founder())
        out << "\t" << p->per->id;
  }

  static Uint numfounders(FP *first) {
    Uint num = 0;
    for (FP *p = first; p != 0; p = (FP *)p->next)
      if (p->per->founder()) num++;
    return num;
  }
  
  static bool hasaffecteddescendants(Person *p, bool strict) {
    if (p->origdstat == AFFECTED && !strict) return true;
    for (Plist *c = p->children; c != 0; c = c->next)
      if (hasaffecteddescendants(c->p, false)) return true;
    return false;
  }
  
};

#endif // _FOUNDERPERSON
