#ifndef _GENOTYPES
#define _GENOTYPES
#include "basic.h"
#include "options.h"

void warning(const string &);

class Marker {
protected:
  static int nextidx;
  Allele a;
public:
  Marker(const char *c) :
      id(c), location(0.0), location_female(0.0), idx(nextidx),
      controlsavailable(false), next(0)

    {nextidx++;}
  void assignrep2allele();
  void addallele(int rep) {
    if (controlsavailable)
      warning("No control frequency available for " + id + " repeat " + rep);
    rep2freq[rep] = options->controlprior;
  }
  FloatVec getfreq(ostream *out = 0);
  string id;
  Float location;
  Float location_female;
  int idx; // Index in genotype lists
  Int2int rep2allele;
  Int2float rep2freq;
  bool controlsavailable;
  Marker *next;
};

enum Chromosometype {AUTOSOMAL, SEXLINKED};

class Chromosome {
protected:
public:
  Chromosome(const char *c) :
      nmarkers(0), id(c), length(0.0), length_female(0.0), firstmarker(0) {}
  Chromosometype type;
  Uint nmarkers;
  string id;
  void add(Marker *m);
  Float length;
  Float length_female;
  Marker *firstmarker;
  Marker *lastmarker;
  Chromosome *next;
};

class PN {
protected:
  static const int repinc = 1000;
  int nrep;
  IntMat rep;
public:
  string id;
  Diseasestatus dstat;

  PN(const char *c) : nrep(0), rep(0), id(c), dstat(UNKNOWN) {}
  ~PN();
  void add(int idx, int r1, int r2);
  IntVec get_rep(int idx) {return idx < nrep ? rep[idx] : 0;}
  bool genotyped() {return nrep > 0;}
};

#endif // _GENOTYPES
