#include "genpairs.h"
#include "family.h"
#include "files.h"
#include "options.h"
#include "vecutil.h"

Genpairsperson::Genpairsperson(Person *p, Genpairsperson *first,
                               String2Double &pair2weight1,
                               String2Double &pair2weight2, Uint &idx,
                               Uint maxnum, bool infm) :
    Pairwiseperson<Indexfounderallele>(p, first), w1(0), w2(0), index(idx),
    informative(infm) {
  if (per->founder()) {
    nod[0]->setmaxnum(maxnum);
    nod[1]->setmaxnum(maxnum);
  }
  if (informative) {
    idx++;
    for (Genpairsperson *q = first; q != 0 && q->per != p;
         q = (Genpairsperson *)q->next) {
      if (q->informative) {
        Double weight1 = pair2weight1[q->per->id + " " + per->id];
        Double weight2 = pair2weight2[q->per->id + " " + per->id];
        if (weight1 != 0.0 || weight2 != 0.0) {
          if (index > 0) {
            if (w1 == 0) {
              assertinternal(w2 == 0);
              NEWVEC(Double, w1, index);
              NEWVEC(Double, w2, index);
              zero(w1, index);
              zero(w2, index);
            }
            assertinternal(index > q->index);
            w1[q->index] = weight1;
            w2[q->index] = weight2;
          }
        }
      }
    }
  }
}

Double Genpairsperson::addgenpairs() {
  Uint i0 = 0, i1 = 0;
  Double sc = 0.0;
  if (!options->sexlinked || per->sex == FEMALE) {
    if (nod[0] != nod[1]) {
      while (i0 < nod[0]->numdescendants && i1 < nod[1]->numdescendants) {
        Uint d0 = nod[0]->descendants[i0];
        Uint d1 = nod[1]->descendants[i1];
        if (d0 < d1) {
          sc += w1[d0];
          i0++;
        }
        else if (d1 < d0) {
          sc += w1[d1];
          i1++;
        }
        else {
          sc += w2[d0];
          i0++;
          i1++;
        }
      }
      while (i0 < nod[0]->numdescendants) {
        Uint d0 = nod[0]->descendants[i0];
        sc += w1[d0];
        i0++;
      }
    }
    else {
      while (i1 < nod[1]->numdescendants) {
        Uint d1 = nod[1]->descendants[i1];
        if (nod[1]->descendanthomozygous[i1])
          sc += w2[d1];
        else
          sc += w1[d1];
        i1++;
      }
    }
  }
  while (i1 < nod[1]->numdescendants) {
    Uint d1 = nod[1]->descendants[i1];
    sc += w1[d1];
    i1++;
  }
  return sc;
}

void Genpairsperson::calcgenspairs(IV v, Double B, DoubleVec S) {
  int Kf = per->patmask ? 1 : 0;
  int Km = per->matmask ? 1 : 0;
  
  for (int K1 = 0; K1 <= Km; K1++) {
    if (K1) v += per->matmask;
    if (per->mother != 0) nod[1] = mother->nod[K1];
    for (int K0 = 0; K0 <= Kf; K0++) {
      if (K0) v += per->patmask;
      if (per->father != 0) nod[0] = father->nod[K0];
      Double Bnew = B;
      if (informative) {
        if (next != 0) {
          bool homozygote = nod[0] == nod[1];
          if (w1 != 0) Bnew += addgenpairs();
          nod[0]->pushdescendant(index, homozygote);
          if ((!options->sexlinked || per->sex == FEMALE) && !homozygote)
            nod[1]->pushdescendant(index, false);
          if (next != 0) ((Genpairsperson *)next)->calcgenspairs(v, Bnew, S);
          nod[0]->popdescendant();
          if ((!options->sexlinked || per->sex == FEMALE) && !homozygote)
            nod[1]->popdescendant();
        }
        else {
          if (w1 != 0) Bnew += addgenpairs();
          S[v] = Bnew;
        }
      }
      else {
        if (next != 0) ((Genpairsperson *)next)->calcgenspairs(v, Bnew, S);
        else S[v] += Bnew;
      }
    }
    v &= ~per->patmask;
  }
}
